AClass(APlayCh) {
	AInt32 *a;
	AInt i1, t1, i;
	AInt len, ch, oct, vol;
	char tai, err;
};

AStatic AInt APlay_getInt(const char **ps, AInt i0)
{
	const char *s = *ps;
	AInt i = 0;
	while (*s == ' ' || *s == '\t') s++;
	if (*s < '0' || '9' < *s) { *ps = s; return i0; }
	while ('0' <= *s && *s <= '9')
		i = i * 10 + (*s++ - '0');
	*ps = s;
	return i;
}

AStatic AInt APlay_getLen(const char **ps, AInt len)
{
	AInt i = APlay_getInt(ps, -1);
	if (i > 0)
		len = 192 / i;
	const char *s = *ps;
	for (;;) {
		while (*s == ' ' || *s == '\t') s++;
		if (*s == '.') {
			s++;
			len += len >> 1;
			continue;
		}
		break;
	}
	*ps = s;
	return len;
}

AClass(APlay) {
	AComArg *aCA;
	APlayCh *ch;
	AInt ch1, t, dt1, n;
	double tu;
	char cmd, mod;
	HMIDIOUT h;
};

AStatic void APlay_mml(APlay *w, AInt j, const char *s)
{
	APlayCh *ch = &w->ch[j];
	AInt i1 = ch->i1, *a = ch->a, chn = ch->ch, t1 = ch->t1;
	static AInt tbl[7] = { 9, 11, 0, 2, 4, 5, 7 };
	if (ch->err != 0) return;
	while (*s != 0) {
		if (*s == ' ' || *s =='\t') {
			s++;
			continue;
		}
		unsigned char c = *s;
		if ('a' <= c && c <= 'z') c -= 'a' - 'A';
		if (c == '@') {
			s++;
			AArySet2ip(a, i1, 2, 0xc0 | chn | APlay_getInt(&s, 0) << 8);
			continue;
		}
		if (c == '>') {
			s++;
			ch->oct++;
			continue;
		}
		if (c == '<') {
			s++;
			ch->oct--;
			continue;
		}
		if (c == 'O') {
			s++;
			ch->oct = APlay_getInt(&s, ch->oct);
			continue;
		}
		if (c == 'V') {
			s++;
			ch->vol = APlay_getInt(&s, ch->vol);
			continue;
		}
		if (c == 'L') {
			s++;
			ch->len = APlay_getLen(&s, ch->len);
			continue;
		}
		if (c == 'R') {
			s++;
			j = APlay_getLen(&s, ch->len);
			t1 += j;
			AArySet2ip(a, i1, 1, t1);
			continue;
		}
		if ('A' <= c && c <= 'G') {
			s++;
			j = tbl[c - 'A'] + ch->oct * 12 + 12;
			while (*s == ' ' || *s == '\t') s++;
			if (*s == '+' || *s == '#') {
				s++;
				j++;
			}
			if (*s == '-') {
				s++;
				j--;
			}
			t1 += APlay_getLen(&s, ch->len);
			if (ch->tai != 0 && i1 >= 6 && a[i1 - 6] == 2 && a[i1 - 5] == (0x90 | chn | j << 8 | ch->vol << 16) && a[i1 - 4] == 1 && a[i1 - 2] == 2 && a[i1 - 1] == (0x80 | chn | j << 8 | ch->vol << 16)) {
				a[i1 - 3] = t1;
				ch->tai = 0;
				continue;
			}
			AArySet6ip(a, i1, 2, 0x90 | chn | j << 8 | ch->vol << 16, 1, t1, 2, 0x80 | chn | j << 8 | ch->vol << 16);
			ch->tai = 0;
			continue;
		}
		if (c == 'T') {
			s++;
			AArySet2ip(a, i1, 4, APlay_getInt(&s, 120));
			continue;
		}
		if (c == '&') {
			s++;
			ch->tai = 1;
			continue;
		}
        ch->err = 1;
		break;
	}
	ch->i1 = i1;
	ch->t1 = t1;
}

AStatic void APlay_run(APlay *w)
{
cmd0:
	w->mod = 0;
	if (w->cmd == 2) {
		midiOutReset(w->h);
		return;
	}
	while (w->cmd == 0)
		Sleep((int) (w->tu * w->dt1));
//cmd1:
	w->mod = 1;
	for (;;) {
		if (w->cmd != 1) goto cmd0;
		AInt tmin = 0x7fffffff;
		AInt t = w->t, i, j;
		for (j = 0; j < w->ch1; j++) {
			i = w->ch[j].i;
			AInt *a = w->ch[j].a, i1 = w->ch[j].i1;
			for (;;) {
				if (i >= i1) break;
				if (a[i] == 1) {	// wait
					if (t < a[i + 1]) {
						if (tmin > a[i + 1]) tmin = a[i + 1];
						break;
					}
					i += 2;
				}
				if (a[i] == 2) {
					midiOutShortMsg(w->h, a[i + 1]);
					i += 2;
				}
				if (a[i] == 3) {
					midiOutReset(w->h);
					i += 2;
				}
				if (a[i] == 4) {
					w->tu = (60000.0 / 48.0) / a[i + 1];
					i += 2;
				}
				if (a[i] == 255) {
					w->cmd = 0;
					goto cmd0;
				}

			}
			w->ch[j].i = i;
		}
		if (tmin >= 0x7fffffff) break;
		if (tmin > t + w->dt1) tmin = t + w->dt1;
		Sleep((int) ((tmin - t) * w->tu));
		w->t = t = tmin;
	}
}
/*
ł჌xȊ֐ƂāA
MidiInit, MidiDein΂H
20bitŉK\B
Ƃnote-on/offƉʕύXƉKύX΂H
*/

#define APlay_init16(w, n)	APlay_init16Ca(aCA, w, n)
AStatic void APlay_init16Ca(AComArg *aCA, APlay *w, AInt n)
// y֐. ƂCjVCUł͂Ȃ.
{
	APlayCh *ch = AMem_malloc(aCA->mem, 16 * sizeof (APlayCh));
	AInt j;
	for (j = 0; j < 16; j++) {
		ch[j].a = AMem_malloc(aCA->mem, n * 2 * sizeof (AInt32));
		ch[j].i1 = 0;
		ch[j].i = 0;
		ch[j].t1 = 0;
		ch[j].len = 192/4;
		ch[j].oct = 4;
		ch[j].ch = j;
		ch[j].vol = 63;
		ch[j].tai = 0;
		ch[j].err = 0;
	}
	w->aCA = aCA;
	midiOutOpen(&w->h, MIDI_MAPPER, 0, 0, 0);
	w->ch = ch;
	w->ch1 = 16;
	w->t = 0;
	w->dt1 = 192 / 8;
	w->tu = (60000.0 / 48.0) / 120; //T120.
	w->cmd = 1;
	w->n = n;
}

#define aOpenPlay16(n)	APlay_open16Ca(aCA, n)
AStatic APlay *APlay_open16Ca(AComArg *aCA, AInt n)
{
	APlay *w = AMem_malloc(aCA->mem, sizeof (APlay));
	APlay_init16(w, n);
	return w;
}

AStatic void APlay_dein(APlay *w)
{
	AInt j;
    APlayCh *ch = w->ch;
	for (j = 0; j < 16; j++) {
		AMem_free(w->aCA->mem, w->n * 2 * sizeof (AInt32), ch[j].a);
	}
    AMem_free(w->aCA->mem, 16 * sizeof (APlayCh), w->ch);
	midiOutReset(w->h);
    midiOutClose(w->h);
}

APlay *AAutoPlay_p = 0;

void AAutoPlay(AComArg *aCA, int j, const char *s)
{
	if (AAutoPlay_p == 0)
		AAutoPlay_p = aOpenPlay16(100000);
	APlay_mml(AAutoPlay_p, j, s);
}
