#include "jpeg.c"

AClass(APic) {
	AInt x, y;
	AUInt8 *p0, *p1;
};

AInt APic_getSizBmp(APic *w)
{
	AUInt8 *p = w->p0;
	if (p[0] != 'B' || p[1] != 'M') return -1; // err.
	if ((p[6] | p[7] | p[8] | p[9]) != 0) return -2; // \̈斢Ή.
	if (p[14] != 0x28 || (p[15] | p[16] | p[17]) != 0) return -2;
	w->x = p[18] | p[19] << 8 | p[20] << 16 | p[21] << 24;
	w->y = p[22] | p[23] << 8 | p[24] << 16 | p[25] << 24;
	if (p[26] != 1 || p[27] != 0) return -2;
	if (p[28] != 24 || p[29] != 0) return -2; // 24bitJ[̂(Ƃ肠).
	if ((p[30] | p[31] | p[32] | p[33]) != 0) return -2; // k̂.
	return 0;
}

AInt APic_loadBmp(APic *w, AWin *v, AInt x0, AInt y0)
{
	AInt i = APic_getSizBmp(w);
	if (i < 0) return i;
	AInt x, y;
	AUInt8 *p = w->p0 + 0x36;
	for (y = 0; y < w->y; y++) {
		AInt i = 0;
		for (x = 0; x < w->x; x++) {
			AInt32 c = p[i + 0] | p[i + 1] << 8 | p[i + 2] << 16;
			i += 3;
			AWin_setPix(v, x + x0, (w->y - 1 - y) + y0, c);
		}
		while ((i & 3) != 0) i++;
		p += i;
	}
	return 0;
}

AInt APic_getSizJpg(APic *w)
{
	struct APic_DLL_STRPICENV env;
	AInt32 info[8];
	if (APic_info_JPEG(&env, info, w->p1 - w->p0, w->p0) == 0) return -1;
	w->x = info[2];
	w->y = info[3];
	return 0;
}

AInt APic_loadJpg(APic *w, AWin *v, AInt x0, AInt y0)
{
	struct APic_DLL_STRPICENV env;
	AInt32 info[8];
	if (APic_info_JPEG(&env, info, w->p1 - w->p0, w->p0) == 0) return -1;
	w->x = info[2];
	w->y = info[3];
	AUInt8 *p = malloc(w->x * w->y * 4);
	if (APic_decode0_JPEG(&env, w->p1 - w->p0, w->p0, 4, (char *) p, 0) != 0) {
		free(p);
		return -1;
	}
	AInt x, y, i = 0;
	for (y = 0; y < w->y; y++) {
		for (x = 0; x < w->x; x++) {
			AInt32 c = p[i + 0] | p[i + 1] << 8 | p[i + 2] << 16;
			i += 4;
			AWin_setPix(v, x + x0, y + y0, c);
		}
	}
	free(p);
	return 0;
}



