AInt aGetExeFileSiz(AUInt8 *p)
{
	p += p[0x3c] | p[0x3d] << 8 | p[0x3e] << 16 | p[0x3f] << 24; // MS-DOSX^ũXLbv.
	if (p[0] != 0x50 || p[1] != 0x45 || p[2] != 0x00 || p[3] != 0x00) return 0;
	int i, sections = p[6] | p[7] << 8;
	p += 0x18 + (p[0x14] | p[0x15] << 8);
	int max = 0x200;
	for (i = 0; i < sections; i++) {
		int ofs1 =  p[0x10] | p[0x11] << 8 | p[0x12] << 16 | p[0x13] << 24;
		    ofs1 += p[0x14] | p[0x15] << 8 | p[0x16] << 16 | p[0x17] << 24;
		if (max < ofs1) max = ofs1;
		p += 0x28;
	}
	return max;
}

AInt aGetSh8(AUInt8 **pp)
{
	AUInt8 *p = *pp;
	AInt c = *p;
	if (c <= 0x7f) { *pp = p + 1; return c; }
	if (c <= 0xbf) { c = (p[0] << 8 | p[1]) & 0x3fff; *pp = p + 2; return c; }
	if (c <= 0xdf) { c = (p[0] << 16 | p[1] << 8 | p[2]) & 0x1fffff; *pp = p + 3; return c; }
	c = (p[0] << 24 | p[1] << 16 | p[2] << 8 | p[3]) & 0x0fffffff; *pp = p + 4; return c;
}

AClass(AEmbFil0Sub) {
	AUInt8 *nam, *p;
	AInt len, siz;
};

AClass(AEmbFil0) {
	void *mem;
	AInt siz;
	AEmbFil0Sub *sub;
};

void AEmbFil0_dein(AEmbFil0 *w)
{
	if (w->siz > 0)
		AMem_free(w->mem, w->siz * aSizeof (AEmbFil0Sub), w->sub);
}

AUInt8 *AEmbFil0_test(AUInt8 *p)
{
	if (p[0] == 0x4d && p[1] == 0x5a) {
		AInt i = aGetExeFileSiz(p);
		if (i <= 0) return 0;
		p += i;
	}
	if (p[0] == 0x05 && p[1] == 0xa5 && p[2] == 0xef && p[3] == 0x00)
		return p + 4;
	return 0;
}

int AEmbFil0_initCa(AEmbFil0 *w, AComArg *aCA, AUInt8 *p)
{
	AInt i;
	w->siz = 0;
	w->mem = aCA->mem;
	p = AEmbFil0_test(p);
	if (p == 0) return 0;
	w->siz = aGetSh8(&p);
	if (w->siz == 0) return 0;
	AEmbFil0Sub *q = w->sub = AMem_malloc(w->mem, w->siz * aSizeof (AEmbFil0Sub));
	for (i = 0; i < w->siz; i++) {
		q->len = aGetSh8(&p);
		q->nam = p;
		p += q->len;
		q->siz = aGetSh8(&p);
		q++;
	}
	q = w->sub;
	for (i = 0; i < w->siz; i++) {
		q->p = p;
		p += q->siz;
		q++;
	}
	return w->siz;
}

AEmbFil0Sub *AEmbFil0_srch(AEmbFil0 *w, AInt len, const AUInt8 *nam)
{
	AInt i;
	AEmbFil0Sub *p = w->sub;
	for (i = 0; i < w->siz; i++) {
		if (len == p->len && memcmp(nam, p->nam, len) == 0) return p;
		p++;
	}
	return 0;
}

