AClass(AArduino) {
	AComArg *ca;
	char ph;
	HANDLE comPort;
	int port;
};

#define AArduino_init(w)	AArduino_initCa(aCA, w, port)
void AArduino_initCa(AComArg *aCA, AArduino *w)
{
	w->ca = aCA;
	w->ph = 0;
	w->port = -1;
}

void AArduino_setPort(AArduino *w, int port)
{
	w->port = port;
}

#define AArduino_initPort(w, port)	AArduino_initPortCa(aCA, w, port)
void AArduino_initPortCa(AComArg *aCA, AArduino *w, int port)
{
	AArduino_initCa(aCA, w);
	AArduino_setPort(w, port);
}

void AArduino_closePort(AArduino *w)
{
	if (w->ph == 1) {
		CloseHandle(w->comPort);
		w->ph = 0;
	}
}

void AArduino_openPort(AArduino *w)
{
	char s[64];
	AArduino_closePort(w);
	if (w->port < 0) {
		aErrExit(w->ca, "AArduino_openPort: no setPort");
	}
	sprintf(s, "\\\\.\\COM%d", w->port);
	w->ph = 1;
	w->comPort = CreateFile(s, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);

	DCB dcb; // VA|[g̍\񂪓\
	GetCommState(w->comPort, &dcb); // ݂̐ݒlǂݍ
	dcb.BaudRate = 115200; // x
	dcb.ByteSize = 8; // f[^
	dcb.Parity = NOPARITY; // peB
	dcb.StopBits = ONESTOPBIT; // Xgbvrbg
	dcb.fOutxCtsFlow = FALSE; // MCTSt[
	dcb.fRtsControl = RTS_CONTROL_ENABLE; // RTSt[
	SetCommState(w->comPort, &dcb); // ύXݒl
}

void AArduino_ledClear(AArduino *w)
{
	static unsigned char a[1] = { 0xf1 };
	DWORD n;
	if (w->ph == 0) AArduino_openPort(w);
	WriteFile(w->comPort, a, sizeof a, &n, NULL);
}

void AArduino_ledFlush(AArduino *w)
{
	static unsigned char a[1] = { 0xf2 };
	DWORD n;
	if (w->ph == 0) AArduino_openPort(w);
	WriteFile(w->comPort, a, sizeof a, &n, NULL);
}

void AArduino_ledSet0(AArduino *w, int i, AInt32 c)
{
	unsigned char a[7];
	DWORD n;
	a[0] = 0xf3;
	a[1] = i >> 8;
	a[2] = i & 0xff;
	a[3] = 1;
	a[4] = (c >> 16) & 0xff;
	a[5] = (c >>  8) & 0xff;
	a[6] =  c        & 0xff;
	if (w->ph == 0) AArduino_openPort(w);
	WriteFile(w->comPort, a, 7, &n, NULL);
}

void AArduino_ledSet1(AArduino *w, int i, int j, AInt32 c)
{
	unsigned char a[4 + 255 * 3];
	int k;
	DWORD n;
	a[0] = 0xf3;
	a[1] = i >> 8;
	a[2] = i & 0xff;
	a[3] = j; // xɐݒł̂255܂.
	for (k = 0; k < j; k++) {
		a[4 + k * 3] = (c >> 16) & 0xff;
		a[5 + k * 3] = (c >>  8) & 0xff;
		a[6 + k * 3] =  c        & 0xff;
	}
	if (w->ph == 0) AArduino_openPort(w);
	WriteFile(w->comPort, a, 4 + j * 3, &n, NULL);
}

void AArduino_ledSet2(AArduino *w, int i, int j, AInt32 *c)
{
	unsigned char a[4 + 255 * 3];
	int k;
	DWORD n;
	a[0] = 0xf3;
	a[1] = i >> 8;
	a[2] = i & 0xff;
	a[3] = j; // xɐݒł̂255܂.
	for (k = 0; k < j; k++) {
		a[4 + k * 3] = (c[k] >> 16) & 0xff;
		a[5 + k * 3] = (c[k] >>  8) & 0xff;
		a[6 + k * 3] =  c[k]        & 0xff;
	}
	if (w->ph == 0) AArduino_openPort(w);
	WriteFile(w->comPort, a, 4 + j * 3, &n, NULL);
}
