#include <acl1.c>

typedef char *String; // Ă String  char * ̑ƂĎg.
typedef int *TknStr; // TknStr  int * ̑.

enum { TcSemi = 1, TcColon, TcNot, TcEEq, TcNEq, TcLt, TcGe, TcLe, TcGt, TcBrOpn, TcBrCls,
    TcSqBrOpn, TcSqBrCls, TcCrBrOpn, TcCrBrCls, TcPlus, TcMinus, TcAster, TcSlash, TcPerce,
    TcAnd, TcXor, TcShr, TcPlPlus, TcEqu, TcComma, TcWiCard, TcExpr, TcExpr0, Tc0, Tc1, TcAndAnd,
    TcOrOr, TcTmp0, TcTmp1, TcTmp2, TcTmp3, TcTmp4, TcTmp5, TcTmp6, TcTmp7, TcTmp8, TcTmp9,
	TcOpLp2, TcOpLp4, TcOpLpc, TcPlEq, TcMiEq, TcAsEq, TcSlEq, TcPrEq, TcAnEq, TcXoEq, TcShrEq };
char tknInit[] = "; : ! == != < >= <= > ( ) [ ] { } + - * / % & ^ >> ++ = , .! .% .& 0 1 && || "
    "_t0 _t1 _t2 _t3 _t4 _t5 _t6 _t7 _t8 _t9 :< :<= _tc0 += -= *= /= %= &= ^= >>=";
enum { OpCpy = 0, OpCeq, OpCne, OpClt, OpCge, OpCle, OpCgt, OpAdd, OpSub, OpMul, OpDiv, OpMod,
    OpAnd = 12, OpXor, OpShr, OpAdd1, OpNeg, OpGoto, OpJeq, OpJne, OpJlt, OpJge, OpJle, OpJgt, OpLoop,
    OpPrint = 25, OpTime, OpEnd, OpPrints, OpAryNew, OpAryInit, OpArySet, OpAryGet, OpPrm,
    OpPrntf1 = 34, OpPrntf2, OpOpnWin, OpSetPix, OpRgb8, OpFilRct, OpSetMod, OpDrwLin, OpFilOvC, OpWait,
    OpSqrt, OpSin, OpCos, OpIsClos, OpMulShr, OpAgMxLI, OpCol16, OpUdMnMx, OpSwpTmp, OpOpWnEx,
    OpEchBox, OpEch, OpRnd, OpGetEch, OpAgMxRI, OpOpnPly, OpPlyMml, OpPlyRun, OpPr, OpPrsp, OpPrlf,
    OpPrs, OpInput, OpPcg0, OpPcg1, OpPcg2, OpPcg3, OpWind, OpBitBlt, OpGrPrn2, OpGrPrn3, OpXorSed,
    OpInkey, OpMoveDx, OpSatInt, OpMaxInt, OpWinCls, OpFilOvl, OpMoveDy, OpPly0, OpPly1, OpPly2,
	OpPly3, OpPly4, OpPly5, OpPris, OpStrchr, OpGetPix, OpLabel, OpEnd1, OpPic, OpCls, OpWinPos, OpWinSiz,
	OpWinAct, OpEchBox1, OpEch1, OpGetEch1, OpWind1, OpGrPrn12, OpGrPrn13, OpInkey1, OpClrKey1 };

AComArg *aCA;
AEmbFil0 embFil[1];
AUInt8 *emb;

FILE *xfopen_rb(const char *path)
{
	AInt len = strlen(path);
	AEmbFil0Sub *sub = AEmbFil0_srch(embFil, len, path);
	if (sub != 0)
		return (FILE *) ((sub - embFil->sub) + 16);
	return fopen(path, "rb");
}

AInt xfread(AUInt8 *b, AInt siz, FILE *fp)
{
	AInt i = (AInt) fp;
	if (16 <= i && i <= 255) {
		AEmbFil0Sub *sub = embFil->sub + (i - 16);
		if (siz > sub->siz)
			siz = sub->siz;
		memcpy(b, sub->p, siz);
		return siz;
	}
	i = fread(b, 1, siz, fp);
	if (i > 0 && AEmbFil0_test(b) != 0) {
		AEmbFil0_dein(embFil);
		memcpy(emb, b, i);
		AEmbFil0_initCa(embFil, aCA, emb);
		AEmbFil0Sub *sub = embFil->sub;
		if (siz > sub->siz)
			siz = sub->siz;
		memcpy(b, sub->p, siz);
		return siz;
	}
	return i;
}

void xfclose(FILE *fp)
{
	AInt i = (AInt) fp;
	if (!(16 <= i && i <= 255))
		fclose(fp);
}

AStatic String loadText(String path)  // t@Cǂݍ.
{
    int siz = 1000000; // 100Ȃ̂ŁAőŖ1MB܂őΉ.
    FILE *fp = xfopen_rb(path);
    if (fp == 0) {
        printf("fopen error : %s\n", path);
        return 0;
    }
    String s = malloc(siz);
    int i = xfread(s, siz - 1, fp);
    xfclose(fp);
    if (i == siz - 1)
        printf("too large file : %s\n", path);
    s[i] = 0; // 0ǉ.
    return realloc(s, i + 1); // s̑傫i+1oCgɕύX̂Ԃ.
}

#define MaxTkn  1000 // g[NR[h̍ől(+1).
String tStr[MaxTkn]; // g[N̓e()L.
int tokens = 1;	// o^ς݂̑g[N.
intptr_t var[MaxTkn]; // ϐ.
#define SzInt  sizeof (intptr_t)

int token(String s)  // g[NR[h߂.
{
    int i, j, k, l;
    for (i = 1; i < tokens; i++) {
        if (strcmp(s, tStr[i]) == 0) return i; // .
    }
    if (i >= MaxTkn - 1) { // ɗƂ i == tokens ɂȂĂ.
        printf("too many tokens\n");
        exit(1);
    }
    tokens++; // Ȃ̂ŐVKo^.
    tStr[i] = malloc(strlen(s) + 1); // sRs[̂ɏ\ȑ傫̔zp.
    var[i] = strtol(strcpy(tStr[i], s), 0, 0); // strcpyŃRs[ĂA萔ꍇɏlݒi萔ł͂ȂƂ0ɂȂj.
    if (tStr[i][0] == 34) { // 擪_uNH[e[V
        j = strlen(s) - 2;
        char *p = malloc(j + 1), *q = tStr[i] + 1;
        var[i] = (intptr_t) p;
        k = 0;
        for (l = 0; l < j;) {
			unsigned char uc = q[l];
			if (0x80 <= uc && uc <= 0x9f) { p[k++] = q[l++]; p[k++] = q[l++]; continue; }
			if (0xe0 <= uc && uc <= 0xfe) { p[k++] = q[l++]; p[k++] = q[l++]; continue; }
            if (q[l] != 92) { // '\'
                p[k++] = q[l++];
                continue;
            }
            l++;
            if (q[l] == 'n') {
                p[k++] = 10;
                l++;
                continue;
            }
            if (q[l] == 'r') {
                p[k++] = 13;
                l++;
                continue;
            }
            p[k++] = q[l++];
        }
        p[k] = 0;
    }
    if (tStr[i][0] == 39) { // 擪VONH[e[V
		var[i] = tStr[i][1];
	}
    return i;
}

AStatic int isTokenConst(int i)
{
	char c = tStr[i][0];
	if ('0' <= c && c <= '9') return 1;
	if (c == 34) return 2;
	if (c == 39) return 1;
	return 0;
}

AStatic int isAlphabetOrNumber(unsigned char c)  // ϐɎgpł镶ǂ.
{
    if ('0' <= c && c <= '9') return 1;
    if ('a' <= c && c <= 'z') return 1;
    if ('A' <= c && c <= 'Z') return 1;
    if (c == '_') return 1;
    return 0;
}

TknStr lexer(String s) // vOg[Nɕϊ.
{
    int pc, qc, len; // pc:s[]̂ǂǂł邩Aqc:ǂ܂ŏo͂ip̎qȂ̂ŁAKqcɂ܂j.
    int siz = 1000000; // ő100g[N܂őΉ.
    if (s == 0) return 0; // sۂȂÂ܂0ԂďI.
    TknStr t = malloc(siz * sizeof (int));  // sizint̔z.
    for (pc = qc = 0; s[pc] != 0;) {
        if (s[pc] == ' ' || s[pc] == '\t' || s[pc] == '\n' || s[pc] == '\r') {	// Xy[XA^uAs.
            pc++;
            continue;
        }
        if (s[pc] == '/' && s[pc + 1] == '/') {
            while (s[pc] != 0 && s[pc] != '\n')
                pc++;
            continue;
        }
        len = 0;
        if (strchr("(){}[];,", s[pc]) != 0) {	// 1L.
            len = 1;
        } else if (isAlphabetOrNumber(s[pc]) != 0) {  // 1ڂp.
            while (isAlphabetOrNumber(s[pc + len]) != 0)
                len++;
        } else if (strchr("=+-*/!%&^~|<>?:.#", s[pc]) != 0) {  // 1ڂʂ̋L.
            while (s[pc + len] != 0 && strchr("=+-*/!%&^~|<>?:.#", s[pc + len]) != 0)
                len++;
        } else if (s[pc] == 34 || s[pc] == 39) { // "" or ''.
            len = 1;
            while (s[pc + len] != s[pc] && (unsigned char) s[pc + len] >= ' ')
                len++;
            if (s[pc + len] == s[pc])
                len++;
        } else {
            printf("syntax error : %.10s\n", &s[pc]);
            free(t);
            return 0;
        }
        char tkn[10000]; // g[N͍őł10000܂.
        tkn[len] = 0; // 0ɓĂ.
        t[qc++] = token(strncpy(tkn, &s[pc], len)); // lenRs[tokenĂяoǍʂtɓ.
        pc += len;
    }
    t[qc] = t[qc + 1] = t[qc + 2] = t[qc + 3] = 0; // 0. 30Ă̂̓G[̒P̂߂̂܂.
    return realloc(t, (qc + 4) * sizeof (int)); // qc+4ɕύX.
}

#define MaxPhr  1000 // t[YECfbNX̍ől.
TknStr phr_tkn[MaxPhr];

int phr(int i, String phrs, TknStr s, int *wpc)
{
    int j, k, pc = wpc[0];
    TknStr t = phr_tkn[i];
    if (t == 0) { // ̌Ăяo.
        t = phr_tkn[i] = lexer(phrs);
        if (phrs[0] != ' ') { // ȗ`𒼂.
            for (j = 0; t[j] != 0; j++) {
                if (t[j] == TcNot)   t[j] = TcWiCard;
                if (t[j] == TcPerce) t[j] = TcExpr;
                if (t[j] == TcAnd)   t[j] = TcExpr0;
            }
        }
    }
    for (j = 0; t[j] != 0; j++) { // r̃[v.
        if (t[j] == TcWiCard && s[pc] != 0) { // ChJ[h.
            wpc[var[t[++j]]] = pc++;  // ̐lǂŁAChJ[hʒuL.
        } else if (t[j] == TcExpr || t[j] == TcExpr0) { // .
            wpc[var[t[++j]]] = pc;  // ̐lǂŁAʒuL.
            for (k = 0; ; pc++) {
                if (s[pc] == TcSemi) break;
                if (s[pc] == TcComma && k == 0) break;
                if (s[pc] == t[j + 1] && k == 0) break;
                if (s[pc] == TcBrOpn || s[pc] == TcSqBrOpn) k++; // 蔲.
                if (s[pc] == TcBrCls || s[pc] == TcSqBrCls) k--;
                if (k < 0) break;
            }
            wpc[var[t[j]] + 1] = pc;  // IʒuL.
            if (t[j - 1] == TcExpr && wpc[var[t[j]]] == pc) return 0; // 0͕sv.
            if (k > 0) return 0; // JbR̐[sv.
        } else if (t[j] != s[pc++])
            return 0; // svȂI.
    }
    wpc[1] = pc; // ǂ܂œǂݐi߂.
    return 1; // t[Yׂ͂Ĉv.
}

#define IcSiz  10000
intptr_t ic[IcSiz], ici; // ic[]:R[hAici:ic[]̂ǂɏނ.

void putIc(int op, int p1, int p2, int p3, int p4)  // ic[]֊ȒPɏނ߂֗̕֐.
{
    ic[ici    ] = op;
    ic[ici + 1] = p1;
    ic[ici + 2] = p2;
    ic[ici + 3] = p3;
    ic[ici + 4] = p4;
    ici += 5;
    if (ici >= IcSiz) {
        printf("ic buffer full\n");
        exit(1);
    }
}

char tmpFlag[10]; // ꎞϐ̗p󋵂Ǘ.

int tmpAlloc() // gp̈ꎞϐm.
{
    int i;
    for (i = 0; i < 10; i++) {
        if (tmpFlag[i] == 0) break;
    }
    if (i >= 10) {
        printf("tmpAlloc: error\n");
        return -1;
    }
    tmpFlag[i] = 1;
    return i + TcTmp0;
}

void tmpFree(int i) // ꎞϐ𖢎gpɖ߂. Aw肳ꂽg[NR[hꎞϐłȂƂ͉Ȃ.
{
    if (TcTmp0 <= i && i <= TcTmp9)
        tmpFlag[i - TcTmp0] = 0;
}

int tmpLabelNo;

int tmpLabelAlloc()
{
    char s[10];
    sprintf(s, "_l%d", tmpLabelNo);
    tmpLabelNo++;
    return token(s);
}

int phrFnc(int i, String phrs, TknStr s, int *wpc, int params, int op, int *pj);

int casmFlg = 0;

AStatic void defLabel(int i)
{
	var[i] = ici;
	if (casmFlg != 0)
		putIc(OpLabel, i, 0, 0, 0);
}

#define Op2(prio)  pc++; e = expr(prio, s, &pc, pc1); j = tmpAlloc(); putIc(op, j, i, e, 0)

int expr(int priority, TknStr s, int *ppc, int pc1)
{
    int pc = *ppc, wpc[99], i = 0, e = 0, j = 0, op; // i͂܂ł̌vZʂĂϐ̃g[NR[hԍ.
    if (pc >= pc1) return 0; // ȂI.
    wpc[0] = pc; // phrg߂̏.
    wpc[1] = 0;
    if (phr(80, "(%2)", s, wpc)) {	// .
        j = expr(99, s, &wpc[2], wpc[3]);
        pc = wpc[1];
    } else if (s[pc] == TcPlPlus) {	// OuCNg.
        pc++; // Zqǂݔ΂.
        j = expr(2, s, &pc, pc1);
        putIc(OpAdd1, j, 0, 0, 0);
    } else if (s[pc] == TcMinus) {	// P}CiX.
        pc++; // Zqǂݔ΂.
        e = expr(2, s, &pc, pc1);
        j = tmpAlloc();
        putIc(OpNeg, j, e, 0, 0);
    } else if (phrFnc(200, "printf(%2)", s, wpc, 1, OpPrntf1, &j)) {
    } else if (phrFnc(201, "printf(%2, %4)", s, wpc, 2, OpPrntf1, &j)) {
    } else if (phrFnc(202, "printf(%2, %4, %6)", s, wpc, 3, OpPrntf1, &j)) {
    } else if (phrFnc(203, "printf(%2, %4, %6, %8)", s, wpc, 4, OpPrntf2, &j)) {
    } else if (phrFnc(204, "printf(%2, %4, %6, %8, %10)", s, wpc, 5, OpPrntf2, &j)) {
    } else if (phrFnc(210, "aOpenWin(%2, %4, %6)", s, wpc, 3, OpOpnWin, &j)) {
    } else if (phrFnc(211, "aSetPix(%2, %4, %6, %8)", s, wpc, 4, OpSetPix, &j)) {
    } else if (phrFnc(212, "aRgb8(%2, %4, %6)", s, wpc, 3, OpRgb8, &j)) {
    } else if (phrFnc(213, "aFillRect(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpFilRct, &j)) {
    } else if (phrFnc(214, "aSetMode(%2, %4)", s, wpc, 2, OpSetMod, &j)) {
    } else if (phrFnc(215, "aDrawLine(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpDrwLin, &j)) {
    } else if (phrFnc(216, "aFillOvalCent(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpFilOvC, &j)) {
    } else if (phrFnc(217, "aWait(%2)", s, wpc, 1, OpWait, &j)) {
    } else if (phrFnc(218, "aFf16Sqrt(%2)", s, wpc, 1, OpSqrt, &j)) {
    } else if (phrFnc(219, "aFf16Sin(%2)", s, wpc, 1, OpSin, &j)) {
    } else if (phrFnc(220, "aFf16Cos(%2)", s, wpc, 1, OpCos, &j)) {
    } else if (phrFnc(221, "AWin_isClose(%2)", s, wpc, 1, OpIsClos, &j)) {
    } else if (phrFnc(222, "aMul64Shr(%2, %4, %6)", s, wpc, 3, OpMulShr, &j)) {
    } else if (phrFnc(223, "aArgMaxLstInt(%2, %4, %6)", s, wpc, 3, OpAgMxLI, &j)) {
    } else if (phrFnc(224, "AWin_col16(%2)", s, wpc, 1, OpCol16, &j)) {
    } else if (phrFnc(225, "AUpdateMinMax(%2, %4, %6)", s, wpc, 3, OpUdMnMx, &j)) {
    } else if (phrFnc(226, "ASwapTmp(%2, %4, %6)", s, wpc, 3, OpSwpTmp, &j)) {
    } else if (phrFnc(227, "aEchBox(%2, %4, %6, %8, %10, %12, %14, %16)", s,wpc,8,OpEchBox,&j)) {
    } else if (phrFnc(228, "aEch(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpEch, &j)) {
    } else if (phrFnc(229, "aRnd(%2)", s, wpc, 1, OpRnd, &j)) {
    } else if (phrFnc(230, "aGetEch(%2, %4, %6)", s, wpc, 3, OpGetEch, &j)) {
    } else if (phrFnc(231, "aArgMaxRndInt(%2, %4, %6)", s, wpc, 3, OpAgMxRI, &j)) {
    } else if (phrFnc(232, "aOpenWinEx(%2, %4, %6)", s, wpc, 3, OpOpWnEx, &j)) {
    } else if (phrFnc(233, "aOpenPlay16(%2)", s, wpc, 1, OpOpnPly, &j)) {
    } else if (phrFnc(234, "APlay_mml(%2, %4, %6)", s, wpc, 3, OpPlyMml, &j)) {
    } else if (phrFnc(235, "APlay_run(%2)", s, wpc, 1, OpPlyRun, &j)) {
    } else if (phrFnc(236, "aPrintTime()", s, wpc, 0, OpTime, &j)) {
    } else if (phrFnc(237, "aInput(%2)", s, wpc, 1, OpInput, &j)) {
    } else if (phrFnc(276, "INPUT(%2)", s, wpc, 1, OpInput, &j)) {
    } else if (phrFnc(238, "aBitBlt(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpBitBlt, &j)) {
    } else if (phrFnc(239, "aGrPrintf(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpGrPrn2, &j)) {
    } else if (phrFnc(240, "aGrPrintf(%2, %4, %6, %8, %10, %12, %14)", s, wpc, 7, OpGrPrn2, &j)) {
    } else if (phrFnc(241, "aGrPrintf(%2, %4, %6, %8, %10, %12, %14, %16)", s, wpc, 8, OpGrPrn3, &j)) {
    } else if (phrFnc(242, "aGrPrintf(%2, %4, %6, %8, %10, %12, %14, %16, %18)", s, wpc, 9, OpGrPrn3, &j)) {
    } else if (phrFnc(243, "aGrPrintf(%2, %4, %6, %8, %10, %12, %14, %16, %18, %20)", s, wpc, 10, OpGrPrn3, &j)) {
    } else if (phrFnc(244, "aInkey(%2, %4)", s, wpc, 2, OpInkey, &j)) {
    } else if (phrFnc(245, "aMoveDx(%2)", s, wpc, 1, OpMoveDx, &j)) {
    } else if (phrFnc(246, "aSaturateInt(%2, %4, %6)", s, wpc, 3, OpSatInt, &j)) {
    } else if (phrFnc(247, "aMaxInt(%2, %4)", s, wpc, 2, OpMaxInt, &j)) {
    } else if (phrFnc(248, "AWin_close(%2)", s, wpc, 1, OpWinCls, &j)) {
    } else if (phrFnc(249, "aFillOval(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpFilOvl, &j)) {
    } else if (phrFnc(250, "aMoveDy(%2)", s, wpc, 1, OpMoveDy, &j)) {
    } else if (phrFnc(251, "pr %2", s, wpc, 1, OpPr, &j)) {
    } else if (phrFnc(252, "PR %2", s, wpc, 1, OpPr, &j)) {
    } else if (phrFnc(253, "prs %2", s, wpc, 1, OpPrs, &j)) {
    } else if (phrFnc(254, "PRS %2", s, wpc, 1, OpPrs, &j)) {
    } else if (phrFnc(255, "prsp", s, wpc, 0, OpPrsp, &j)) {
    } else if (phrFnc(256, "PRSP", s, wpc, 0, OpPrsp, &j)) {
    } else if (phrFnc(257, "prlf", s, wpc, 0, OpPrlf, &j)) {
    } else if (phrFnc(258, "PRLF", s, wpc, 0, OpPrlf, &j)) {
    } else if (phrFnc(259, "play %2", s, wpc, 1, OpPly0, &j)) {
    } else if (phrFnc(260, "PLAY %2", s, wpc, 1, OpPly0, &j)) {
    } else if (phrFnc(261, "play1 %2", s, wpc, 1, OpPly1, &j)) {
    } else if (phrFnc(262, "PLAY1 %2", s, wpc, 1, OpPly1, &j)) {
    } else if (phrFnc(263, "play2 %2", s, wpc, 1, OpPly2, &j)) {
    } else if (phrFnc(264, "PLAY2 %2", s, wpc, 1, OpPly2, &j)) {
    } else if (phrFnc(270, "play3 %2", s, wpc, 1, OpPly3, &j)) {
    } else if (phrFnc(271, "PLAY3 %2", s, wpc, 1, OpPly3, &j)) {
    } else if (phrFnc(272, "play4 %2", s, wpc, 1, OpPly4, &j)) {
    } else if (phrFnc(273, "PLAY4 %2", s, wpc, 1, OpPly4, &j)) {
    } else if (phrFnc(274, "play5 %2", s, wpc, 1, OpPly5, &j)) {
    } else if (phrFnc(275, "PLAY5 %2", s, wpc, 1, OpPly5, &j)) {
	} else if (phrFnc(265, "aXorShift32_seed(%2)", s, wpc, 1, OpXorSed, &j)) {
    } else if (phrFnc(266, "pris %2", s, wpc, 1, OpPris, &j)) {
    } else if (phrFnc(267, "PRIS %2", s, wpc, 1, OpPris, &j)) {
    } else if (phrFnc(268, "strchr(%2, %4)", s, wpc, 2, OpStrchr, &j)) {
	} else if (phrFnc(269, "aGetPix(%2, %4, %6)", s, wpc, 3, OpGetPix, &j)) {
    } else if (phrFnc(277, "PRINTF(%2)", s, wpc, 1, OpPrntf1, &j)) {
    } else if (phrFnc(278, "PRINTF(%2, %4)", s, wpc, 2, OpPrntf1, &j)) {
    } else if (phrFnc(279, "PRINTF(%2, %4, %6)", s, wpc, 3, OpPrntf1, &j)) {
    } else if (phrFnc(280, "PRINTF(%2, %4, %6, %8)", s, wpc, 4, OpPrntf2, &j)) {
    } else if (phrFnc(281, "PRINTF(%2, %4, %6, %8, %10)", s, wpc, 5, OpPrntf2, &j)) {
    } else if (phrFnc(282, "RND(%2)", s, wpc, 1, OpRnd, &j)) {
    } else if (phrFnc(283, "END", s, wpc, 0, OpEnd1, &j)) {
    } else if (phrFnc(284, "CLS", s, wpc, 0, OpCls, &j)) {
    } else if (phrFnc(285, "ECHBOX(%2, %4, %6, %8, %10, %12, %14)", s,wpc,7,OpEchBox1,&j)) {
    } else if (phrFnc(286, "ECH(%2, %4, %6, %8, %10)", s, wpc, 5, OpEch1, &j)) {
    } else if (phrFnc(287, "GETECH(%2, %4)", s, wpc, 2, OpGetEch1, &j)) {
    } else if (phrFnc(288, "ECHWIN(%2, %4)", s, wpc, 2, OpWind1, &j)) {
    } else if (phrFnc(289, "GPRINTF(%2, %4, %6, %8, %10)", s, wpc, 5, OpGrPrn12, &j)) {
    } else if (phrFnc(290, "GPRINTF(%2, %4, %6, %8, %10, %12)", s, wpc, 6, OpGrPrn12, &j)) {
    } else if (phrFnc(291, "GPRINTF(%2, %4, %6, %8, %10, %12, %14)", s, wpc, 7, OpGrPrn12, &j)) {
    } else if (phrFnc(292, "GPRINTF(%2, %4, %6, %8, %10, %12, %14, %16)", s, wpc, 8, OpGrPrn13, &j)) {
    } else if (phrFnc(293, "GPRINTF(%2, %4, %6, %8, %10, %12, %14, %16, %18)", s, wpc, 9, OpGrPrn13, &j)) {
    } else if (phrFnc(294, "INKEY(%2)", s, wpc, 1, OpInkey1, &j)) {
    } else if (phrFnc(295, "CLRKEY", s, wpc, 0, OpClrKey1, &j)) {
    } else if (phrFnc(296, "WAIT(%2)", s, wpc, 1, OpWait, &j)) {



//295-

#if 0
        } else if (phr(45, "pcg0 %2, %4, %6;", s, wpc) || phr(46, "PCG0 %2, %4, %6;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            i = expr(99, s, &wpc[4], wpc[5]);
            j = expr(99, s, &wpc[6], wpc[7]);
            putIc(OpPcg0, e, i, j, 0);
	        tmpFree(i);
	        tmpFree(j);
        } else if (phr(47, "pcg1 %2;", s, wpc) || phr(48, "PCG1 %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPcg1, e, 0, 0, 0);
        } else if (phr(49, "pcg2 %2;", s, wpc) || phr(50, "PCG2 %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPcg2, e, 0, 0, 0);
        } else if (phr(51, "pcg3 %2;", s, wpc) || phr(52, "PCG3 %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPcg3, e, 0, 0, 0);
        } else if (phr(53, "window %2, %4;", s, wpc) || phr(54, "WINDOW %2, %4;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            i = expr(99, s, &wpc[4], wpc[5]);
            putIc(OpWind, e, i, 0, 0);
	        tmpFree(i);
#endif

//randseed

    } else // ϐ͒萔.
        j = s[pc++];
    if (wpc[1] > 0)
        pc = wpc[1];
    for (;;) {
        tmpFree(i);
        tmpFree(e);
        i = j;
        if (j < 0 || e < 0) { tmpFree(i); return -1; }	// ܂łŃG[΁Ał؂.
        if (pc >= pc1) break;
        j = e = 0;
        wpc[0] = pc; // phrg߂̏.
        if (s[pc] == TcPlPlus) {		// uCNg.
            pc++;
            j = tmpAlloc();
            putIc(OpCpy,  j, i, 0, 0);
            putIc(OpAdd1, i, 0, 0, 0);
        } else if (phr(81, "[%2]=", s, wpc) && priority >= 15) {
            e = expr(99, s, &wpc[2], wpc[3]);
            pc = wpc[1];
            j = expr(15, s, &pc, pc1);	// EȂ̂15̂܂.
            putIc(OpArySet, i, e, j, 0);
        } else if (phr(82, "[%2]", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            pc = wpc[1];
            j = tmpAlloc();
            putIc(OpAryGet, i, e, j, 0);
        } else if (TcAster <= s[pc] && s[pc] <= TcPerce && priority >= 4) {
            op = OpMul + s[pc] - TcAster; Op2(3); // Ȃ̂41.
        } else if (TcPlus  <= s[pc] && s[pc] <= TcMinus && priority >= 5) {
            op = OpAdd + s[pc] - TcPlus;  Op2(4); // Ȃ̂51.
        } else if (s[pc] == TcShr && priority >= 6) {
            op = OpShr;                   Op2(5); // Ȃ̂51.
        } else if (TcLt    <= s[pc] && s[pc] <= TcGt    && priority >= 7) {
            op = OpClt + s[pc] - TcLt;    Op2(6); // Ȃ̂71.
        } else if (TcEEq   <= s[pc] && s[pc] <= TcNEq   && priority >= 8) {
            op = OpCeq + s[pc] - TcEEq;   Op2(7); // Ȃ̂81.
        } else if (s[pc] == TcAnd && priority >= 9) {
            op = OpAnd;                   Op2(8); // Ȃ̂91.
        } else if (s[pc] == TcXor && priority >= 10) {
            op = OpXor;                   Op2(9); // Ȃ̂101.
        } else if (s[pc] == TcAndAnd && priority >= 12) {
            pc++;
            j = tmpAlloc();
            putIc(OpCpy,  j, Tc0, 0, 0);
            int label = tmpLabelAlloc();
            putIc(OpJeq, label, 0, i, Tc0);
            e = expr(11, s, &pc, pc1); // Ȃ̂121.
            putIc(OpJeq, label, 0, e, Tc0);
            putIc(OpCpy,  j, Tc1, 0, 0);
            defLabel(label); // x`.
        } else if (s[pc] == TcOrOr && priority >= 13) {
            pc++;
            j = tmpAlloc();
            putIc(OpCpy,  j, Tc1, 0, 0);
            int label = tmpLabelAlloc();
            putIc(OpJne, label, 0, i, Tc0);
            e = expr(12, s, &pc, pc1); // Ȃ̂131.
            putIc(OpJne, label, 0, e, Tc0);
            putIc(OpCpy,  j, Tc0, 0, 0);
            defLabel(label); // x`.
        } else if (s[pc] == TcEqu && priority >= 15) {
            pc++;
            e = expr(15, s, &pc, pc1);	// EȂ̂15̂܂.
            putIc(OpCpy, i, e, 0, 0);
            j = i; i = 0;
		} else if (TcPlEq <= s[pc] && s[pc] <= TcShrEq && priority >= 15) {
			op = OpAdd + (s[pc] - TcPlEq);
            pc++;
            e = expr(15, s, &pc, pc1);	// EȂ̂15̂܂.
            putIc(op, i, i, e, 0);
            j = i; i = 0;
        } else
            break; // 𖞂̂ȂΑł؂.
    }
    if (priority == 99 && pc < pc1) { tmpFree(i); return -1; } // Ō܂ŉ߂łȂG[.
    *ppc = pc; // pc̒l*ppc֏߂.
    return i;
}

enum { IfTrue = 0, IfFalse = 1 };

void ifgoto(TknStr s, int pc, int pc1, int not, int label, int *pe)
{
    if (pc1 - pc == 3 && TcEEq <= s[pc + 1] && s[pc + 1] <= TcGt) { // ̒3g[NŁA^񒆂rZq.
        putIc(((s[pc + 1] - TcEEq) ^ not) + OpJeq, label, 0, s[pc], s[pc + 2]);
    } else {
        int i = expr(99, s, &pc, pc1);
        putIc(OpJne - not, label, 0, i, Tc0);
        tmpFree(i);
        if (i < 0) {
            tmpFree(*pe);
            *pe = -1;
        }
    }
}

int phrFnc(int i, String phrs, TknStr s, int *wpc, int params, int op, int *pj)
{
    int e[11];
    if (phr(i, phrs, s, wpc) == 0) return 0;
    int j = tmpAlloc();
    for (i = 0; i < 11; i++)
        e[i] = 0;
    for (i = 0; i < params; i++)
        e[i] = expr(99, s, &wpc[i * 2 + 2], wpc[i * 2 + 3]);
    putIc(op, j, e[0], e[1], e[2]);
    if (params >= 4)
        putIc(OpPrm, e[3], e[4], e[5], e[6]);
    if (params >= 8)
        putIc(OpPrm, e[7], e[8], e[9], e[10]);
    for (i = 0; i < params; i++) {
        tmpFree(e[i]);
        if (e[i] < 0) {
            tmpFree(j);
            j = -1;
        }
    }
    *pj = j;
    return 1;
}

#define BInfSiz  10
int binf[BInfSiz * 100], bd, lbd; // binf:block-info, bd:block-depth, lbd:loop-block-depth
enum { BlkIf = 1, BlkFor };
enum { IfLabel0 = 1, IfLabel1 };
enum { ForLopBgn = 1, ForCont, ForBrk, ForLbd0, ForWpc4, ForWpc5, ForWpc6, ForWpc7, ForFlag };
#define S(i)  s[wpc[i]]

int defArray(TknStr s, int pc, int *pe)
{
	int wpc[99];
    wpc[0] = pc;
    pc++; // ^̖Oǂݔ΂(intȂ).
    while (s[pc - 1] != TcSemi) {
        int e = 0, i, j;
        wpc[0] = pc;
		if (phr(100, "!2[%3];", s, wpc) || phr(101, "!2[%3],", s, wpc)) {
            e = expr(99, s, &wpc[3], wpc[4]);
            putIc(OpAryNew, S(2), e, 0, 0);
		} else if (phr(102, "!2[%3] = {", s, wpc)) {
            e = expr(99, s, &wpc[3], wpc[4]);
            putIc(OpAryNew, S(2), e, 0, 0);
            j = 0; // R}ȊÕg[N𐔂.
            for (i = wpc[1]; s[i] != 0 && s[i] != TcCrBrCls; i++) {
                if (s[i] != TcComma && s[i] != TcMinus) j++;
            }
            if (s[i] != TcCrBrCls) {
                tmpFree(e);
                *pe = -1;
                break;
            }
            intptr_t *ip = malloc(j * SzInt);
            j = 0;
            for (i = wpc[1]; s[i] != TcCrBrCls; i++) {
                if (s[i] == TcMinus) {
                    ip[j++] = - var[s[++i]];
                } else if (s[i] != TcComma)
                    ip[j++] = var[s[i]];
            }
            putIc(OpAryInit, S(2), (intptr_t) ip, j, 0);
            wpc[1] = i + 2; // },܂łǂݔ΂( }; Ȃ).
        } else if (phr(103, "*", s, wpc)) { // int *a ݂ȃp^[. ЂƂ܂ * ǂݔ΂.
            pc++;
            continue;
        } else if (phr(104, "!2,", s, wpc) || phr(105, "!2;", s, wpc)) { // Ȃ.
        } else if (phr(106, "!2 = %3,", s, wpc) || phr(107, "!2 = %3;", s, wpc)) {
            e = expr(99, s, &wpc[3], wpc[4]);
            putIc(OpCpy, S(2), e, 0, 0);
        } else
            break; // 悭킩Ȃ̂łЂƂ܂break;
        tmpFree(e);
        if (e < 0) {
            *pe = -1;
            break;
        }
        pc = wpc[1]; // R}̓Z~R܂łǂݔ΂.
    }
    return pc;
}

int SearchSemi(TknStr s, int i, int i1)
{
	int k = 0;
	for (;;) {
		if (i >= i1) return i;
		if (s[i] == TcBrOpn || s[i] == TcSqBrOpn) k++;
		if (s[i] == TcBrCls || s[i] == TcSqBrCls) k--;
		if (k < 0) return i;
		if (k == 0 && s[i] == TcSemi) return i;
		if (k == 0 && s[i] == TcCrBrOpn) return i;
		if (k == 0 && s[i] == TcCrBrCls) return i;
		i++;
	}
}

AStatic int compile(String src)
{
    int pc, wpc[99], i, j;
    TknStr s = lexer(src);
    if (s == 0) return 1;
    for (pc = 0; s[pc] != 0; pc++); // ܂œǂݔ΂.
    s[pc] = TcSemi; // Ɂu;vtY邱Ƃ̂ŁAtĂ.
	int pc1 = pc + 1;
	ici = 0; // ݈ʒu.
    for (i = 0; i < 10; i++) // ꎞϐׂĖgpɂ.
        tmpFlag[i] = 0;
    tmpLabelNo = 0;
    bd = lbd = 0;
	int opLpPc1 = -1;
    for (pc = 0; ;) { // RpCJn.


		if (pc == opLpPc1) {
			defLabel(binf[bd + ForCont]); // x`.
            putIc(OpAdd1, TcOpLpc, 0, 0, 0);
			if (binf[bd + ForWpc4] == TcOpLp2)
	        	putIc(OpJlt, binf[bd + ForLopBgn], 0, TcOpLpc, binf[bd + ForWpc5]);
			if (binf[bd + ForWpc4] == TcOpLp4)
	        	putIc(OpJle, binf[bd + ForLopBgn], 0, TcOpLpc, binf[bd + ForWpc5]);
            defLabel(binf[bd + ForBrk]); // x`.
            lbd = binf[bd + ForLbd0]; // ȑO̒l𕜌.
            bd -= BInfSiz;
		}
	if (s[pc] == 0) break;
        int e = 0;
        wpc[0] = pc;
        if (phr(2, "[!2= !3!4!5]{", s, wpc) && (S(4) == TcOpLp2 || S(4) == TcOpLp4)) {
            bd += BInfSiz;
            binf[bd] = BlkFor; // ubÑ^Cv.
            binf[bd + ForLopBgn] = tmpLabelAlloc(); // [v̓ɖ߂p.
            binf[bd + ForCont  ] = tmpLabelAlloc(); // continuep.
            binf[bd + ForBrk   ] = tmpLabelAlloc(); // breakp.
            binf[bd + ForLbd0  ] = lbd; // Âlۑ.
            binf[bd + ForWpc4  ] = S(4);
            binf[bd + ForWpc5  ] = S(5);
            binf[bd + ForWpc6  ] = S(2);
         //   binf[bd + ForWpc7  ] = 0;
            binf[bd + ForFlag  ] = 1;
            lbd = bd;
            putIc(OpCpy, S(2), S(3), 0, 0);
			if (S(4) == TcOpLp2)
	        	putIc(OpJge, binf[bd + ForBrk], 0, S(2), S(5)); // ŏsȂbreak.
			if (S(4) == TcOpLp4)
	        	putIc(OpJgt, binf[bd + ForBrk], 0, S(2), S(5)); // ŏsȂbreak.
            defLabel(binf[bd + ForLopBgn]); // x`.
			goto phrFound;
        }
        if (phr(30, "[!2]{", s, wpc)) {
            bd += BInfSiz;
            binf[bd] = BlkFor; // ubÑ^Cv.
            binf[bd + ForLopBgn] = tmpLabelAlloc(); // [v̓ɖ߂p.
            binf[bd + ForCont  ] = tmpLabelAlloc(); // continuep.
            binf[bd + ForBrk   ] = tmpLabelAlloc(); // breakp.
            binf[bd + ForLbd0  ] = lbd; // Âlۑ.
            binf[bd + ForWpc4  ] = TcOpLp2;
            binf[bd + ForWpc5  ] = S(2);
            binf[bd + ForWpc6  ] = TcOpLpc;
         //   binf[bd + ForWpc7  ] = 0;
            binf[bd + ForFlag  ] = 1;
            lbd = bd;
            putIc(OpCpy, TcOpLpc, Tc0, 0, 0);
        	putIc(OpJge, binf[bd + ForBrk], 0, TcOpLpc, S(2)); // ŏsȂbreak.
            defLabel(binf[bd + ForLopBgn]); // x`.
			goto phrFound;
        }
		i = SearchSemi(s, pc, pc1);
		if (s[i] == TcSemi) i++;
		for (j = pc; j < i; j++) {
			if (s[j] == TcOpLp2) break;
			if (s[j] == TcOpLp4) break;
		}
		if (j < i && j > 0 && s[j - 1] != TcBrCls && s[j + 1] != TcBrOpn) {
            bd += BInfSiz;
            binf[bd] = BlkFor; // ubÑ^Cv.
            binf[bd + ForLopBgn] = tmpLabelAlloc(); // [v̓ɖ߂p.
            binf[bd + ForCont  ] = tmpLabelAlloc(); // continuep.
            binf[bd + ForBrk   ] = tmpLabelAlloc(); // breakp.
            binf[bd + ForLbd0  ] = lbd; // Âlۑ.
            binf[bd + ForWpc4  ] = s[j];
            binf[bd + ForWpc5  ] = s[j + 1];
            binf[bd + ForWpc6  ] = TcOpLpc;
         //   binf[bd + ForWpc7  ] = 0;
            binf[bd + ForFlag  ] = 1;
            lbd = bd;
            putIc(OpCpy, TcOpLpc, s[j - 1], 0, 0);
			if (s[j] == TcOpLp2)
	        	putIc(OpJge, binf[bd + ForBrk], 0, TcOpLpc, s[j + 1]); // ŏsȂbreak.
			if (s[j] == TcOpLp4)
	        	putIc(OpJgt, binf[bd + ForBrk], 0, TcOpLpc, s[j + 1]); // ŏsȂbreak.
            defLabel(binf[bd + ForLopBgn]); // x`.
			s[j - 1] = TcBrOpn;
			s[j] = TcOpLpc;
			s[j + 1] = TcBrCls;
			opLpPc1 = i;
		}
		if (phr( 0, "!2 = !3;", s, wpc)) {
            putIc(OpCpy, S(2), S(3), 0, 0);
        } else if (phr(10, "!2 = !3 + 1; if (!4 < !5) goto !6;", s, wpc) && S(2) == S(3) && S(2) == S(4)) {
            putIc(OpLoop, S(6), 0, S(2), S(5));
        } else if (phr( 9, "!2 = !3 + 1;", s, wpc) && S(2) == S(3)) { // eNjbN#2
            putIc(OpAdd1, S(2), 0, 0, 0);
        } else if (phr( 1, "!2 = !3 !4 !5;", s, wpc) && TcPlus <= S(4) && S(4) <= TcShr) {
            putIc(OpAdd + S(4) - TcPlus, S(2), S(3), S(5), 0);
        } else if (phr( 3, "print %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPrint, e, 0, 0, 0);
        } else if (phr( 4, "goto !2;", s, wpc) || phr(36, "GO !2;", s, wpc)) {
            putIc(OpGoto, S(2), 0, 0, 0);
        } else if (phr( 5, "if (%2) goto !4;", s, wpc) || phr(37, "IF (%2) GO !4;", s, wpc)) {
            ifgoto(s, wpc[2], wpc[3], IfTrue, S(4), &e);
        } else if (phr( 6, "time;", s, wpc)) {
            putIc(OpTime, 0, 0, 0, 0);
        } else if (phr( 7, "!2:", s, wpc)) {
            defLabel(S(2));
        } else if (phr(11, "if (%2) {", s, wpc) || phr(38, "IF (%2) {", s, wpc)) {	// 	ubNif.
            bd += BInfSiz;
            binf[bd] = BlkIf;
            binf[bd + IfLabel0] = tmpLabelAlloc(); // ŝƂ̔ѐ.
            binf[bd + IfLabel1] = 0;
            ifgoto(s, wpc[2], wpc[3], IfFalse, binf[bd + IfLabel0], &e); // 𖞂Ȃ΁Abinf[bd + IfLabel0]goto.
        } else if (phr(12, "} else {", s, wpc) && binf[bd] == BlkIf) {
            binf[bd + IfLabel1] = tmpLabelAlloc(); // else߂̏I[.
            putIc(OpGoto, binf[bd + IfLabel1], 0, 0, 0);
            defLabel(binf[bd + IfLabel0]);	// x`.
        } else if (phr( 13, "}", s, wpc) && binf[bd] == BlkIf) {
            if (binf[bd + IfLabel1] == 0) { // elseȂꍇ.
                defLabel(binf[bd + IfLabel0]);	// x`.
            } else {
                defLabel(binf[bd + IfLabel1]);	// x`.
            }
            bd -= BInfSiz;
        } else if (phr(14, "for (&2; &4; &6) {", s, wpc) || phr(55, "FOR (&2; &4; &6) {", s, wpc)) {	// for
            bd += BInfSiz;
            binf[bd] = BlkFor; // ubÑ^Cv.
            binf[bd + ForLopBgn] = tmpLabelAlloc(); // [v̓ɖ߂p.
            binf[bd + ForCont  ] = tmpLabelAlloc(); // continuep.
            binf[bd + ForBrk   ] = tmpLabelAlloc(); // breakp.
            binf[bd + ForLbd0  ] = lbd; // Âlۑ.
            binf[bd + ForWpc4  ] = wpc[4];
            binf[bd + ForWpc5  ] = wpc[5];
            binf[bd + ForWpc6  ] = wpc[6];
            binf[bd + ForWpc7  ] = wpc[7];
            binf[bd + ForFlag  ] = 0;
            lbd = bd;
            e = expr(99, s, &wpc[2], wpc[3]);
            if (wpc[4] < wpc[5]) // &4ɎĂ.
                ifgoto(s, wpc[4], wpc[5], IfFalse, binf[bd + ForBrk], &e); // ŏsȂbreak.
            defLabel(binf[bd + ForLopBgn]); // x`.
        } else if (phr(15, "}", s, wpc) && binf[bd] == BlkFor) {
            defLabel(binf[bd + ForCont]); // x`.
			if (binf[bd + ForFlag] == 0) {
	            i = binf[bd + ForWpc4];
    	        j = binf[bd + ForWpc6];
        	    if (binf[bd + ForWpc5] - i == 3 && binf[bd + ForWpc7] - j == 2 && s[i] == s[j] && s[i + 1] == TcLt && s[j + 1] == TcPlPlus) {
            	    // &4ui < ?vA&6ui++viϐiȂĂǁAʂłKvj.
                	putIc(OpLoop, binf[bd + ForLopBgn], 0, s[i], s[i + 2]);
            	} else {
                	wpc[4] = binf[bd + ForWpc4];
                	wpc[5] = binf[bd + ForWpc5];
                	wpc[6] = binf[bd + ForWpc6];
                	wpc[7] = binf[bd + ForWpc7];
                	e = expr(99, s, &wpc[6], wpc[7]);
                	if (wpc[4] < wpc[5]) {	// &4ɉ炩̎Ă.
                    	ifgoto(s, wpc[4], wpc[5], IfTrue, binf[bd + ForLopBgn], &e);
                	} else
                    	putIc(OpGoto, binf[bd + ForLopBgn], 0, 0, 0);
            	}
			} else {
            	putIc(OpAdd1, binf[bd + ForWpc6], 0, 0, 0);
				if (binf[bd + ForWpc4] == TcOpLp2)
	        		putIc(OpJlt, binf[bd + ForLopBgn], 0, binf[bd + ForWpc6], binf[bd + ForWpc5]);
				if (binf[bd + ForWpc4] == TcOpLp4)
	        		putIc(OpJle, binf[bd + ForLopBgn], 0, binf[bd + ForWpc6], binf[bd + ForWpc5]);
			}
            defLabel(binf[bd + ForBrk]); // x`.
            lbd = binf[bd + ForLbd0]; // ȑO̒l𕜌.
            bd -= BInfSiz;
        } else if (phr(16, "continue;", s, wpc) && lbd > 0) {
            putIc(OpGoto, binf[lbd + ForCont], 0, 0, 0);
        } else if (phr(17, "break;", s, wpc) && lbd > 0) {
            putIc(OpGoto, binf[lbd + ForBrk ], 0, 0, 0);
        } else if (phr(18, "if (%2) continue;", s, wpc) && lbd > 0) {
            ifgoto(s, wpc[2], wpc[3], IfTrue, binf[lbd + ForCont], &e);
        } else if (phr(19, "if (%2) break;", s, wpc) && lbd > 0) {
            ifgoto(s, wpc[2], wpc[3], IfTrue, binf[lbd + ForBrk], &e);
        } else if (phr(20, "prints %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPrints, e, 0, 0, 0);
        } else if (phr(21, "int", s, wpc) || phr(22, "AWin", s, wpc) || phr(24, "AInt", s, wpc)) {
            wpc[1] = defArray(s, pc, &e);
        } else if (phr(23, "static", s, wpc)) {
        } else if (phr(25, "APlay", s, wpc) || phr(26, "AInt32", s, wpc) || phr(27, "char", s, wpc)) {
            wpc[1] = defArray(s, pc, &e);
        } else if (phr(28, "while (%4) {", s, wpc)) {	// while
            bd += BInfSiz;
            binf[bd] = BlkFor; // ubÑ^Cv.
            binf[bd + ForLopBgn] = tmpLabelAlloc(); // [v̓ɖ߂p.
            binf[bd + ForCont  ] = tmpLabelAlloc(); // continuep.
            binf[bd + ForBrk   ] = tmpLabelAlloc(); // breakp.
            binf[bd + ForLbd0  ] = lbd; // Âlۑ.
            binf[bd + ForWpc4  ] = wpc[4];
            binf[bd + ForWpc5  ] = wpc[5];
            binf[bd + ForWpc6  ] = wpc[5];
            binf[bd + ForWpc7  ] = wpc[5];
            binf[bd + ForFlag  ] = 0;
            lbd = bd;
            ifgoto(s, wpc[4], wpc[5], IfFalse, binf[bd + ForBrk], &e); // ŏsȂbreak.
            defLabel(binf[bd + ForLopBgn]); // x`.



//        } else if (phr(28, "pr %2;", s, wpc) || phr(32, "PR %2;", s, wpc)) {
//            e = expr(99, s, &wpc[2], wpc[3]);
//            putIc(OpPr, e, 0, 0, 0);
//        } else if (phr(29, "prs %2;", s, wpc) || phr(33, "PRS %2;", s, wpc)) {
//            e = expr(99, s, &wpc[2], wpc[3]);
//            putIc(OpPrs, e, 0, 0, 0);
//        } else if (phr(30, "prsp;", s, wpc) || phr(34, "PRSP;", s, wpc)) {
//            putIc(OpPrsp, 0, 0, 0, 0);
//        } else if (phr(31, "prlf;", s, wpc) || phr(35, "PRLF;", s, wpc)) {
//            putIc(OpPrlf, 0, 0, 0, 0);
//        } else if (phr(39, "play %2;", s, wpc) || phr(40, "PLAY %2;", s, wpc)) {
//            e = expr(99, s, &wpc[2], wpc[3]);
//            putIc(OpPly, Tc0, e, 0, 0);
//        } else if (phr(41, "play1 %2;", s, wpc) || phr(42, "PLAY1 %2;", s, wpc)) {
//            e = expr(99, s, &wpc[2], wpc[3]);
//            putIc(OpPly, Tc1, e, 0, 0);
//        } else if (phr(43, "play2 %2;", s, wpc) || phr(44, "PLAY2 %2;", s, wpc)) {
//            e = expr(99, s, &wpc[2], wpc[3]);
//            putIc(OpPly, Tc2, e, 0, 0);

        } else if (phr(45, "pcg0 %2, %4, %6;", s, wpc) || phr(46, "PCG0 %2, %4, %6;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            i = expr(99, s, &wpc[4], wpc[5]);
            j = expr(99, s, &wpc[6], wpc[7]);
            putIc(OpPcg0, e, i, j, 0);
	        tmpFree(i);
	        tmpFree(j);
        } else if (phr(47, "pcg1 %2;", s, wpc) || phr(48, "PCG1 %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPcg1, e, 0, 0, 0);
        } else if (phr(49, "pcg2 %2;", s, wpc) || phr(50, "PCG2 %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPcg2, e, 0, 0, 0);
        } else if (phr(51, "pcg3 %2;", s, wpc) || phr(52, "PCG3 %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPcg3, e, 0, 0, 0);
        } else if (phr(53, "window %2, %4;", s, wpc) || phr(54, "WINDOW %2, %4;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            i = expr(99, s, &wpc[4], wpc[5]);
            putIc(OpWind, e, i, 0, 0);
	        tmpFree(i);
	    } else if (phr(56, "PICTURE %2, %4, %6;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            i = expr(99, s, &wpc[4], wpc[5]);
            j = expr(99, s, &wpc[6], wpc[7]);
            putIc(OpPic, 0, e, i, j);
	        tmpFree(i);
	        tmpFree(j);
	    } else if (phr(57, "PICTURE %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpPic, 0, e, Tc0, Tc0);
	    } else if (phr(58, "WINPOS %2, %4, %6;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            i = expr(99, s, &wpc[4], wpc[5]);
            j = expr(99, s, &wpc[6], wpc[7]);
            putIc(OpWinPos, 0, e, i, j);
	        tmpFree(i);
	        tmpFree(j);
	    } else if (phr(59, "WINSIZ %2, %4, %6;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            i = expr(99, s, &wpc[4], wpc[5]);
            j = expr(99, s, &wpc[6], wpc[7]);
            putIc(OpWinSiz, 0, e, i, j);
	        tmpFree(i);
	        tmpFree(j);
	    } else if (phr(60, "WINACT %2;", s, wpc)) {
            e = expr(99, s, &wpc[2], wpc[3]);
            putIc(OpWinAct, 0, e, 0, 0);
        } else if (phr(61, "CONTINUE;", s, wpc) && lbd > 0) {
            putIc(OpGoto, binf[lbd + ForCont], 0, 0, 0);
        } else if (phr(62, "BREAK;", s, wpc) && lbd > 0) {
            putIc(OpGoto, binf[lbd + ForBrk ], 0, 0, 0);


        } else if (phr( 8, "&2;", s, wpc)) { // ͂Ȃ}b`₷̂ōŌɂ.
            e = expr(99, s, &wpc[2], wpc[3]);
        } else {
err:
            printf("syntax error : %s %s %s %s %s %s %s %s %s %s\n", tStr[s[pc]], tStr[s[pc + 1]], tStr[s[pc + 2]], tStr[s[pc + 3]], tStr[s[pc + 4]], tStr[s[pc + 5]], tStr[s[pc + 6]], tStr[s[pc + 7]], tStr[s[pc + 8]], tStr[s[pc + 9]]);
            free(s); // s.
            return 1; // G[I.
        }
phrFound:
        tmpFree(e);
        if (e < 0) goto err;
        pc = wpc[1]; // Z~R̎܂œǂݔ΂.
    }
    free(s); // s.
    putIc(OpEnd, 0, 0, 0, 0);
    if (bd > 0) {
        printf("block nesting error (bd=%d, lbd=%d)\n", bd, lbd);
        return 1; // G[I.
    }
    for (ici = 0; ic[ici] != OpEnd; ici += 5) {  // goto̍.
        if (OpGoto <= ic[ici] && ic[ici] <= OpLoop) {
            i = var[ic[ici + 1]];
            while (ic[i] == OpGoto)
                i = var[ic[i + 1]];
            ic[ici + 2] = i;
        }
    }
    return 0; // I.
}

int CtrlC = FALSE, CtrlCEvnt;
APlay *ply;

BOOL WINAPI CtrlHandler(DWORD fdwCtrlType)
{
	if (fdwCtrlType == CTRL_C_EVENT) {
		CtrlCEvnt = 1;
        if (ply != 0)
            ply->cmd = 2; //abort.
		return CtrlC; // Ԃ.
	}
	return FALSE;
}

AWin *win;
int autoPlayPhase;
AInt prLmt, prLmt0 = 500;
#define V(i)  var[ic[pc + i]]
#define Nxt(i)   pc += 5 * i; continue
#define Jmp   pc = ic[pc + 2]; continue

void plySub(int i, String s)
{
    if (autoPlayPhase == 0) {
        if (ply != 0)
            APlay_dein(ply);
        ply = aOpenPlay16(100000);
        autoPlayPhase = 1;
    }
    APlay_mml(ply, i, s);
}

void cls(HANDLE hConsole)
{
    CONSOLE_SCREEN_BUFFER_INFO csbi;
    SMALL_RECT scrollRect;
    COORD scrollTarget;
    CHAR_INFO fill;

    // Get the number of character cells in the current buffer.
    if (!GetConsoleScreenBufferInfo(hConsole, &csbi))
    {
        return;
    }

    // Scroll the rectangle of the entire buffer.
    scrollRect.Left = 0;
    scrollRect.Top = 0;
    scrollRect.Right = csbi.dwSize.X;
    scrollRect.Bottom = csbi.dwSize.Y;

    // Scroll it upwards off the top of the buffer with a magnitude of the entire height.
    scrollTarget.X = 0;
    scrollTarget.Y = (SHORT)(0 - csbi.dwSize.Y);

    // Fill with empty spaces with the buffer's default text attribute.
    fill.Char.UnicodeChar = TEXT(' ');
    fill.Attributes = csbi.wAttributes;

    // Do the scroll
    ScrollConsoleScreenBuffer(hConsole, &scrollRect, NULL, scrollTarget, &fill);

    // Move the cursor to the top left corner too.
    csbi.dwCursorPosition.X = 0;
    csbi.dwCursorPosition.Y = 0;

    SetConsoleCursorPosition(hConsole, csbi.dwCursorPosition);
}

void exec(clock_t t0)
{
    intptr_t pc = 0, i, j, *a;
    CtrlCEvnt = 0;
    autoPlayPhase = 0;
	prLmt = prLmt0 + 1;
    for (;;) {
        if (CtrlCEvnt != 0) break;
        switch (ic[pc]) {
        case OpNeg:     V(1) = - V(2); Nxt(1);
        case OpAdd1:    V(1)++; Nxt(1);
        case OpMul:     V(1) = V(2) *  V(3); Nxt(1);
        case OpDiv:     V(1) = V(2) /  V(3); Nxt(1);
        case OpMod:     V(1) = V(2) %  V(3); Nxt(1);
        case OpAdd:     V(1) = V(2) +  V(3); Nxt(1);
        case OpSub:     V(1) = V(2) -  V(3); Nxt(1);
        case OpShr:     V(1) = V(2) >> V(3); Nxt(1);
        case OpClt:     V(1) = V(2) <  V(3); Nxt(1);
        case OpCge:     V(1) = V(2) >= V(3); Nxt(1);
        case OpCle:     V(1) = V(2) <= V(3); Nxt(1);
        case OpCgt:     V(1) = V(2) >  V(3); Nxt(1);
        case OpCeq:     V(1) = V(2) == V(3); Nxt(1);
        case OpCne:     V(1) = V(2) != V(3); Nxt(1);
        case OpAnd:     V(1) = V(2) &  V(3); Nxt(1);
        case OpXor:     V(1) = V(2) ^  V(3); Nxt(1);
        case OpCpy:     V(1) = V(2); Nxt(1);
        case OpPrint:   printf("%d\n", V(1)); Nxt(1);
        case OpGoto:    Jmp;
        case OpJlt:     if (V(3) <  V(4)) { Jmp; } Nxt(1);
        case OpJge:     if (V(3) >= V(4)) { Jmp; } Nxt(1);
        case OpJle:     if (V(3) <= V(4)) { Jmp; } Nxt(1);
        case OpJgt:     if (V(3) >  V(4)) { Jmp; } Nxt(1);
        case OpJeq:     if (V(3) == V(4)) { Jmp; } Nxt(1);
        case OpJne:     if (V(3) != V(4)) { Jmp; } Nxt(1);
        case OpTime:
            printf("time: %.3f[sec]\n", (clock() - t0) / (double) CLOCKS_PER_SEC);
            Nxt(1);
        case OpEnd:
        case OpEnd1:
            if (autoPlayPhase != 0)
                APlay_run(ply);
            return;
        case OpLoop:    i = V(3) + 1; V(3) = i; if (i < V(4)) { Jmp; } Nxt(1);
        case OpPrints:  printf("%s\n", (char *) V(1)); Nxt(1);
        case OpAryNew:
            V(1) = (intptr_t) malloc(V(2) * SzInt);
            memset((char *) V(1), 0, V(2) * SzInt);
            Nxt(1);
        case OpAryInit:
            memcpy((char *) V(1), (char *) ic[pc + 2], ic[pc + 3] * SzInt);
            Nxt(1);
        case OpOpnWin:
            if (win != 0) { AWin_closeCa(aCA, win); }
            V(1) = (intptr_t) (win = aOpenWin(V(2), V(3), (String) V(4)));
            Nxt(1);
        case OpOpWnEx:
            if (win != 0) { AWin_dein(win); }
            V(1) = (intptr_t) (win = aOpenWinEx(V(2), V(3), (String) V(4)));
            Nxt(1);
        case OpOpnPly:
            if (ply != 0)
                APlay_dein(ply);
            V(1) = (intptr_t) (ply = aOpenPlay16(V(2)));
            Nxt(1);
        case OpArySet:  a = (intptr_t *) V(1); a[V(2)] = V(3); Nxt(1);
        case OpAryGet:  a = (intptr_t *) V(1); V(3) = a[V(2)]; Nxt(1);
        case OpPrntf1:  V(1) = printf((String) V(2), V(3), V(4)); Nxt(1);
        case OpPrntf2:  V(1) = printf((String) V(2), V(3), V(4), V(6), V(7), V(8), V(9)); Nxt(2);
        case OpSetPix:  aSetPix((AWin *) V(2), V(3), V(4), V(6)); Nxt(2);
        case OpRgb8:    V(1) = aRgb8(V(2), V(3), V(4)); Nxt(1);
        case OpFilRct:  aFillRect((AWin *) V(2), V(3), V(4), V(6), V(7), V(8)); Nxt(2);
        case OpSetMod:  aSetMode((AWin *) V(2), V(3)); Nxt(1);
        case OpDrwLin:  aDrawLine((AWin *) V(2), V(3), V(4), V(6), V(7), V(8)); Nxt(2);
        case OpFilOvC:  aFillOvalCent((AWin *) V(2), V(3), V(4), V(6), V(7), V(8)); Nxt(2);
        case OpWait:
            for (i = V(2); i > 0; ) {
                j = i;
                if (j > 256) j = 256;
                aWait(j);
                i -= j;
                if (CtrlCEvnt != 0) break;
            }
            Nxt(1);
        case OpSqrt:    V(1) = aFf16Sqrt(V(2)); Nxt(1);
        case OpSin:     V(1) = aFf16Sin(V(2)); Nxt(1);
        case OpCos:     V(1) = aFf16Cos(V(2)); Nxt(1);
        case OpIsClos:  V(1) = AWin_isClose((AWin *) V(2)); Nxt(1);
        case OpMulShr:  V(1) = aMul64Shr(V(2), V(3), V(4)); Nxt(1);
        case OpAgMxLI:  V(1) = aArgMaxLstInt((AInt *) V(2), V(3), V(4)); Nxt(1);
        case OpCol16:   V(1) = AWin_col16(V(2)); Nxt(1);
        case OpUdMnMx:  if (V(2) > V(4)) { V(2) = V(4); } if (V(3) < V(4)) { V(3) = V(4); } Nxt(1);
        case OpSwpTmp:  V(4) = V(2); V(2) = V(3); V(3) = V(4); Nxt(1);
        case OpEchBox:  aEchBox((AWin *) V(2), V(3), V(4), V(6), V(7), V(8), V(9), V(11)); Nxt(3);
        case OpEch:     aEch((AWin *) V(2), V(3), V(4), V(6), V(7), V(8)); Nxt(2);
        case OpRnd:     V(1) = aRnd(V(2)); Nxt(1);
        case OpGetEch:  V(1) = aGetEch((AWin *) V(2), V(3), V(4)); Nxt(1);
        case OpAgMxRI:  V(1) = aArgMaxRndInt((AInt *) V(2), V(3), V(4)); Nxt(1);
        case OpPlyMml:  APlay_mml((APlay *) V(2), V(3), (String) V(4)); Nxt(1);
        case OpPlyRun:  APlay_run((APlay *) V(2)); Nxt(1);
        case OpPr:      if (prLmt > 0) { prLmt--; if (prLmt == 0) { printf("\n!PRLIMIT!(%d)\n", prLmt0); return; } } printf("%d ", V(2)); Nxt(1);
        case OpPrsp:    printf(" "); Nxt(1);
        case OpPrlf:    printf("\n"); Nxt(1);
        case OpPrs:     printf("%s ", (char *) V(2)); Nxt(1);
        case OpInput:   if (win!=0) { AWin_flushAll(win); } V(1) = (AInt) aInput((char *) V(2)); Nxt(1);
        case OpPly0:    plySub(0, (String) V(2)); Nxt(1);
        case OpPly1:    plySub(1, (String) V(2)); Nxt(1);
        case OpPly2:    plySub(2, (String) V(2)); Nxt(1);
        case OpPly3:    plySub(3, (String) V(2)); Nxt(1);
        case OpPly4:    plySub(4, (String) V(2)); Nxt(1);
        case OpPly5:    plySub(5, (String) V(2)); Nxt(1);
        case OpWind:
			if (AAutoPcg_p != 0) {
				APcg_dein(AAutoPcg_p);
				AAutoPcg_p = 0;
			}
            if (win != 0) { AWin_dein(win); }
            win = aOpenWin(V(1), V(2), "graphics");
            Nxt(1);
		case OpPcg0:   AAutoPcg0(aCA, V(1), V(2), V(3)); Nxt(1);
		case OpPcg1:   AAutoPcg1(aCA, (char *) V(1)); Nxt(1);
		case OpPcg2:   AAutoPcg2(aCA, (char *) V(1)); AAutoPcg_p->win = win; Nxt(1);
		case OpPcg3:   AAutoPcg3(aCA, (char *) V(1)); Nxt(1);
        case OpBitBlt: aBitBlt((AWin *) V(2), V(3), V(4), V(6), V(7), (AInt *) V(8)); Nxt(2);
        case OpGrPrn2: aGrPrintf((AWin *) V(2), V(3), V(4), V(6), V(7), (String) V(8), V(9)); Nxt(2);
        case OpGrPrn3: aGrPrintf((AWin *) V(2), V(3), V(4), V(6), V(7), (String) V(8), V(9), V(11), V(12), V(13), V(14)); Nxt(3);
        case OpInkey:  V(1) = aInkey((AWin *) V(2), V(3)); Nxt(1);
        case OpMoveDx: V(1) = aMoveDx(V(2)); Nxt(1);
        case OpSatInt: V(1) = aSaturateInt(V(2), V(3), V(4)); Nxt(1);
        case OpMaxInt: V(1) = aMaxInt(V(2), V(3)); Nxt(1);
        case OpWinCls: AWin_closeCa(aCA, (AWin *) V(2)); win = 0; Nxt(1);
        case OpFilOvl: aFillOval((AWin *) V(2), V(3), V(4), V(6), V(7), V(8)); Nxt(2);
        case OpMoveDy: V(1) = aMoveDy(V(2)); Nxt(1);
        case OpXorSed: aXorShift32_seed(V(2)); Nxt(1);
        case OpPris:   printf("%d ", V(2)); Nxt(1);
        case OpStrchr: V(1) = (AInt) strchr((char *) V(2), V(3)); Nxt(1);
		case OpGetPix: V(1) = aGetPix((AWin *) V(2), V(3), V(4)); Nxt(1);
		case OpPic:
			if (win != 0) {
				FILE *fp = xfopen_rb((char *) V(2));
				if (fp != 0) {
					char *b = malloc(16 * 1024 * 1024);
					i = xfread(b, 16 * 1024 * 1024, fp);
					xfclose(fp);
					APic w[1]; w->p0 = b; w->p1 = b + i;
					if (APic_getSizBmp(w) == 0)
						APic_loadBmp(w, win, V(3), V(4));
					if (APic_getSizJpg(w) == 0)
						APic_loadJpg(w, win, V(3), V(4));
					free(b);
				}
			}
			Nxt(1);
		case OpCls:		//aWait(200); system("cls"); Nxt(1);
cls(GetStdHandle(STD_OUTPUT_HANDLE)); Nxt(1);
		case OpWinPos: {
				ARpa rpa[1]; ARpa_init(rpa);
				ARpa_Win rpaWin = ARpa_srchWinNam(rpa, (char *) V(2), 0);
				ARpa_setWinPos(rpa, rpaWin, V(3), V(4));
				ARpa_dein(rpa);
				Nxt(1);
			}
		case OpWinSiz: {
				ARpa rpa[1]; ARpa_init(rpa);
				ARpa_Win rpaWin = ARpa_srchWinNam(rpa, (char *) V(2), 0);
				ARpa_setWinSiz(rpa, rpaWin, V(3), V(4));
				ARpa_dein(rpa);
				Nxt(1);
			}
		case OpWinAct: {
				ARpa rpa[1]; ARpa_init(rpa);
				ARpa_Win rpaWin = ARpa_srchWinNam(rpa, (char *) V(2), 0);
				ARpa_activeWin(rpa, rpaWin);
				ARpa_dein(rpa);
				Nxt(1);
			}
        case OpEchBox1: aEchBox(win, V(2), V(3), V(4), V(6), V(7), V(8), V(9)); printf("%d ", V(2)); Nxt(2);
        case OpEch1:    aEch(win, V(2), V(3), V(4), V(6), V(7)); Nxt(2);
        case OpGetEch1: V(1) = aGetEch(win, V(2), V(3)); Nxt(1);
        case OpWind1:
			if (AAutoPcg_p != 0) {
				APcg_dein(AAutoPcg_p);
				AAutoPcg_p = 0;
			}
            if (win != 0) { AWin_dein(win); }
            win = aOpenWinEx(V(2), V(3), "graphics");
            Nxt(1);
        case OpGrPrn12: aGrPrintf(win, V(2), V(3), V(4), V(6), (String) V(7), V(8), V(9)); Nxt(2);
        case OpGrPrn13: aGrPrintf(win, V(2), V(3), V(4), V(6), (String) V(7), V(8), V(9), V(11), V(12), V(13), V(14)); Nxt(3);
        case OpInkey1:  V(1) = aInkey(win, V(2)); Nxt(1);
		case OpClrKey1: aClrKeybuf(win); Nxt(1);
        }

    }
}

int casm_label_table[4096], casm_labels;

void casm_label_init()
{
	casm_labels = 2;
}

int casm_label(int i)
{
	int j;
	for (j = 2; j < casm_labels; j++) {
		if (casm_label_table[j] == i) return j;
	}
	casm_label_table[j] = i;
	casm_labels++;
	return  j;
}

AClass(CasmRegMan) {
	int reg1, reg0, table[256], tmp;
};

void CasmRegMan_rstTmp(CasmRegMan *w)
{
	w->tmp = -1;
}

void CasmRegMan_init(CasmRegMan *w, int reg0)
{
	w->reg1 = w->reg0 = reg0;
	CasmRegMan_rstTmp(w);
}

int CasmRegMan_reg(CasmRegMan *w, int i)
{
	int j;
	for (j = w->reg0; j < w->reg1; j++) {
		if (w->table[j] == i) return j;
	}
	w->table[j] = i;
	w->reg1++;
	return j;
}

int CasmRegMan_alcTmp(CasmRegMan *w)
{
	return CasmRegMan_reg(w, w->tmp--);
}

int CasmRegMan_reg1(CasmRegMan *w, int i)
{
	if (isTokenConst(i) == 0)
		return CasmRegMan_reg(w, i);
	int j = CasmRegMan_alcTmp(w);
	printf("LdImm32(R%02x, %d)\n", j, var[i]);
	return j;
}

char ptrFlg[MaxTkn];

int CasmRegMan_regPtr(CasmRegMan *w, int i)
{
	ptrFlg[i] = 1;
	return CasmRegMan_reg(w, i);
}

int CasmRegMan_regPtr1(CasmRegMan *w, int i)
{
	if (isTokenConst(i) == 0)
		return CasmRegMan_regPtr(w, i);
	int j = CasmRegMan_alcTmp(w);
	printf("LdPtrImm(P%02x, %s);\n", j, tStr[i]);
	return j;
}

CasmRegMan regMan[1], regPtrMan[1];

#define Reg0(i)	CasmRegMan_reg(regMan, i)
#define Reg1(i)	CasmRegMan_reg1(regMan, i)
#define RegPtr0(i)	CasmRegMan_regPtr(regPtrMan, i)
#define RegPtr1(i)	CasmRegMan_regPtr1(regPtrMan, i)

#if 0

int casm_reg_table[256], casm_regs;

void casm_reg_init()
{
	casm_regs = 1;
}

int casm_reg0(int i)
{
	int j;
	for (j = 1; j < casm_regs; j++) {
		if (casm_reg_table[j] == i) return j;
	}
	casm_reg_table[j] = i;
	casm_regs++;
	return j;
}

int casm_reg1(int i)
{
	if (isTokenConst(i) != 0) {
		printf("LdImm32(R00, %d);\n", var[i]);
		return 0;
	}
	return casm_reg0(i);
}

#endif

void casm_alu(String op, intptr_t *icpc)
{
	if (isTokenConst(icpc[3]) == 0) {
		printf("%sLng32(R%02x, R%02x, R%02x);\n", op, Reg0(icpc[1]), Reg1(icpc[2]), Reg0(icpc[3]));
	} else {
		printf("%sLngImm32(R%02x, R%02x, %d);\n", op, Reg0(icpc[1]), Reg1(icpc[2]), var[icpc[3]]);
	}
}

void casm_cmpSet(String op, intptr_t *icpc)
{
	if (isTokenConst(icpc[3]) == 0) {
		printf("CmpSet%s32(R%02x, R%02x, R%02x);\n", op, Reg0(icpc[1]), Reg1(icpc[2]), Reg0(icpc[3]));
	} else {
		printf("CmpSet%sImm32(R%02x, R%02x, %d);\n", op, Reg0(icpc[1]), Reg1(icpc[2]), var[icpc[3]]);
	}
}

void casm_cmpJmp(String op, intptr_t *icpc)
{
	if (isTokenConst(icpc[4]) == 0) {
		printf("CmpJmp%s32(R%02x, R%02x, %d);\n", op, Reg1(icpc[3]), Reg0(icpc[4]), casm_label(icpc[1]));
	} else {
		printf("CmpJmp%sImm32(R%02x, %d, %d);\n", op, Reg1(icpc[3]), var[icpc[4]], casm_label(icpc[1]));
	}
}

void casm(clock_t t0)
{
    intptr_t pc = 0;
    CtrlCEvnt = 0;
    autoPlayPhase = 0;
//	casm_reg_init();
	casm_label_init();
	CasmRegMan_init(regMan, 0);
	CasmRegMan_init(regPtrMan, 2);
	memset(ptrFlg, 0, MaxTkn);
    for (;;) {
        if (CtrlCEvnt != 0) break;
		CasmRegMan_rstTmp(regMan);
		CasmRegMan_rstTmp(regPtrMan);
        switch (ic[pc]) {
		default:		printf("err: op=%d\n", ic[pc]); return;
        case OpEnd:		printf("End();\n"); return;
        case OpPrint:	printf("ApiPrintReg32(R%02x);\n", Reg1(ic[pc + 1])); Nxt(1);
        case OpNeg:		printf("MulShtImm32(R%02x, -1);\n", Reg0(ic[pc + 1])); Nxt(1);
        case OpAdd1:	printf("AddShtImm32(R%02x, 1);\n", Reg0(ic[pc + 1])); Nxt(1);
        case OpMul:		casm_alu("Mul", &ic[pc]); Nxt(1);
        case OpDiv:		casm_alu("Div", &ic[pc]); Nxt(1);
        case OpMod:		casm_alu("Mod", &ic[pc]); Nxt(1);
        case OpAdd:		casm_alu("Add", &ic[pc]); Nxt(1);
        case OpSub:		casm_alu("Sub", &ic[pc]); Nxt(1);
        case OpShr:		casm_alu("Shr", &ic[pc]); Nxt(1);
        case OpAnd:		casm_alu("And", &ic[pc]); Nxt(1);
        case OpXor:		casm_alu("Xor", &ic[pc]); Nxt(1);
        case OpClt:		casm_cmpSet("LesThn", &ic[pc]); Nxt(1);
        case OpCge:		casm_cmpSet("GrtEqu", &ic[pc]); Nxt(1);
        case OpCle:		casm_cmpSet("LesEqu", &ic[pc]); Nxt(1);
        case OpCgt:		casm_cmpSet("GrtThn", &ic[pc]); Nxt(1);
        case OpCeq:		casm_cmpSet("Equ",    &ic[pc]); Nxt(1);
        case OpCne:		casm_cmpSet("NotEqu", &ic[pc]); Nxt(1);
		case OpCpy:
			if (ptrFlg[ic[pc + 2]] != 0) {
				printf("CpyPtr(P%02x, P%02x);\n", RegPtr0(ic[pc + 1]), RegPtr0(ic[pc + 2]));  Nxt(1);
			} else {
				if (isTokenConst(ic[pc + 2]) == 0) {
					printf("Cpy32(R%02x, R%02x);\n", Reg0(ic[pc + 1]), Reg0(ic[pc + 2]));  Nxt(1);
				} else {
					printf("LdImm32(R%02x, %d);\n", Reg0(ic[pc + 1]), var[ic[pc + 2]]);  Nxt(1);
				}
			}
        case OpGoto:    printf("Jmp(%d);\n", casm_label(ic[pc + 1])); Nxt(1);
        case OpJlt:     casm_cmpJmp("LesThn", &ic[pc]); Nxt(1);
        case OpJge:     casm_cmpJmp("GrtEqu", &ic[pc]); Nxt(1);
        case OpJle:     casm_cmpJmp("LesEqu", &ic[pc]); Nxt(1);
        case OpJgt:     casm_cmpJmp("GrtThn", &ic[pc]); Nxt(1);
        case OpJeq:     casm_cmpJmp("Equ",    &ic[pc]); Nxt(1);
        case OpJne:     casm_cmpJmp("NotEqu", &ic[pc]); Nxt(1);
        case OpLoop:
			if (isTokenConst(ic[pc + 4]) == 0) {
			    printf("AddShtImm32(R%02x, 1);\nCmpJmpLesThn32(R%02x, R%02x, %d);\n",  Reg0(ic[pc + 3]), Reg0(ic[pc + 3]), Reg0(ic[pc + 4]), casm_label(ic[pc + 1])); Nxt(1);
			} else {
			    printf("AddShtImm32(R%02x, 1);\nCmpJmpLesThnImm32(R%02x, %d, %d);\n",  Reg0(ic[pc + 3]), Reg0(ic[pc + 3]), var[ic[pc + 4]], casm_label(ic[pc + 1])); Nxt(1);
			}
			Nxt(1);
		case OpLabel:	printf("Label(%d);\n", casm_label(ic[pc + 1])); Nxt(1);
        case OpPr:      printf("ApiPrIntReg32(R%02x);\n", Reg1(ic[pc + 2])); Nxt(1);
		case OpPrs:		printf("ApiPrStrReg(P%02x);\n", RegPtr1(ic[pc + 2])); Nxt(1);
		case OpOpnWin:	printf("ApiOpenWinReg32(P%02x, R%02x, R%02x, P%02x);\n", RegPtr0(ic[pc + 1]), Reg1(ic[pc + 2]), Reg1(ic[pc + 3]), RegPtr1(ic[pc + 4])); Nxt(1);
        case OpSetPix:  printf("ApiSetPix32(P%02x, R%02x, R%02x, R%02x);\n", RegPtr0(ic[pc + 2]), Reg1(ic[pc + 3]), Reg1(ic[pc + 4]), Reg1(ic[pc + 6])); Nxt(2);
		}
    }
}


int run(String src, int fre)
{
    clock_t t0 = clock();
	int i = compile(src);
    if (fre != 0 && src != 0) // \[XR[h̎J.
        free(src);
    if (i != 0) return 1;
	if (casmFlg == 0)
 	   exec(t0);
	else
		casm(t0);
    if (win != 0)
        AWin_flushAll(win);
    return 0;
}

void aMain(AComArg *aCA0)
{
	SetConsoleCtrlHandler(CtrlHandler, TRUE);
	aCA = aCA0;
	int argc = aGetArgc();
	String *argv = aGetArgv();
	emb = AMem_malloc(aCA->mem, 16 * 1024 * 1024);
	if (argc == 1) {
		FILE *fp = fopen(argv[0], "rb");
		if (fp == 0) {
			char tmp[1024];
			sprintf(tmp, "%s.exe", argv[0]);
			fp = fopen(tmp, "rb");
		}
		fread(emb, 1, 16 * 1024 * 1024, fp);
		fclose(fp);
		AEmbFil0_initCa(embFil, aCA, emb);
	}
    free(lexer(tknInit));
    tStr[0] = ""; // G[̂.
    run("AWinMode_Xor=3;AWinKey_Esc=27;AWinKey_Enter=10;AWinKey_Left=0x1024;AWinKey_Right=0x1025;AWinKey_Up=0x1026;AWinKey_Down=0x1027", 0);
    if (argc >= 2) // R}hC.
        exit(run(loadText(argv[1]), 1));
	if (embFil->siz > 0)
        run(loadText("autorun.c"), 1);
    CtrlC = TRUE;
    for (;;) { // Read-Eval-Print Loop.
        char cmdlin[10000];
        printf("\nHL9>"); // vvg\.
        cmdlin[0] = 0;
        fgets(cmdlin, sizeof cmdlin, stdin);
        if (cmdlin[strlen(cmdlin) - 1] == '\n')
            cmdlin[strlen(cmdlin) - 1] = 0; // ɉsR[hΏ.
        if (strncmp(cmdlin, "run ", 4) == 0 || strncmp(cmdlin, "RUN ", 4) == 0) { // runR}h.
            CtrlC = TRUE;
            run(loadText(&cmdlin[4]), 1);
//            CtrlC = FALSE;
        } else if (strcmp(cmdlin, "exit") == 0 || strcmp(cmdlin, "EXIT") == 0) { // exitR}h.
            exit(0);
		} else if (strncmp(cmdlin, "casm ", 5) == 0) {
			casmFlg = strtol(&cmdlin[5], 0, 0);
        } else if (cmdlin[0] == '$' && cmdlin[1] == '$') { // shellR}h.
            CtrlC = TRUE;
            memmove(&cmdlin[6], &cmdlin[2], sizeof cmdlin - 6);
            memcpy(cmdlin, "start ", 6);
            system(cmdlin);
//            CtrlC = FALSE;
        } else if (cmdlin[0] == '$') { // shellR}h.
            CtrlC = TRUE;
            system(&cmdlin[1]);
//            CtrlC = FALSE;
        } else if (strncmp(cmdlin, "!run ", 5) == 0 || strncmp(cmdlin, "!RUN ", 5) == 0) {
            CtrlC = TRUE;
            ACA_EasyC_run(aCA, &cmdlin[5], "ec_tmp");
//            CtrlC = FALSE;
        } else if (cmdlin[0] == '!') {
            CtrlC = TRUE;
            ACA_EasyC_exec(aCA, &cmdlin[1], "ec_tmp");
//            CtrlC = FALSE;
        } else if (strncmp(cmdlin, "new ", 4) == 0 || strncmp(cmdlin, "NEW ", 4) == 0) {
            FILE *fp = fopen(&cmdlin[4], "ab");
            fclose(fp);
        } else if (strncmp(cmdlin, "prlimit ", 8) == 0 || strncmp(cmdlin, "PRLIMIT ", 8) == 0) {
			double d = strtod(cmdlin + 8, 0);
			prLmt0 = (AInt) d;
			if (d > 60000.0 || d <= 0.0) prLmt0 = -1;
        } else { // ȊO.
            CtrlC = TRUE;
            run(cmdlin, 0);
//            CtrlC = FALSE;
        }
    }
}
