AInt aGcd(AInt a, AInt b)
{
	if (a < b) goto skp0;
	if (b == 0) goto skp1;
	do {
		a %= b;
skp0:
		if (a == 0) goto skp2;
		b %= a;
	} while (b > 0);
skp1:
	return a;
skp2:
	return b;
}

AInt aAbsInt(AInt i)
{
	if (i < 0) { i = - i; }
	return i;
}

AClass(ARat)
{
	AInt a, b;
};

ARat ARat_new(AInt a, AInt b)
{
	ARat r;
	r.a = a;
	r.b = b;
	return r;
}

void ARat_print(ARat r)
{
	printf("%d:/%d", r.a, r.b);
}

ARat ARat_irreducible(ARat r)
{
	AInt g = aGcd(aAbsInt(r.a), r.b);
	if (g > 1) { r.a /= g; r.b /= g; }
	return r;
}

ARat ARat_add(ARat r, ARat s)
{
	r = ARat_irreducible(r);
	s = ARat_irreducible(s);
	int g = aGcd(r.b, s.b);
	int bg = r.b / g, bd = bg * s.b;
	int ac = r.a * (s.b / g) + s.a * bg;
	g = aGcd(aAbsInt(ac), bd);
	if (g > 1) { ac /= g; bd /= g; }
	return ARat_new(ac, bd);
}

ARat ARat_sub(ARat r, ARat s)
{
	r = ARat_irreducible(r);
	s = ARat_irreducible(s);
	int g = aGcd(r.b, s.b);
	int bg = r.b / g, bd = bg * s.b;
	int ac = r.a * (s.b / g) - s.a * bg;
	g = aGcd(aAbsInt(ac), bd);
	if (g > 1) { ac /= g; bd /= g; }
	return ARat_new(ac, bd);
}

ARat ARat_mul(ARat r, ARat s)
{
	r = ARat_irreducible(r);
	s = ARat_irreducible(s);
	int g;
	g = aGcd(aAbsInt(r.a), s.b);
	if (g > 1) { r.a /= g; s.b /= g; }
	g = aGcd(aAbsInt(s.a), r.b);
	if (g > 1) { s.a /= g; r.b /= g; }
	return ARat_new(r.a * s.a, r.b * s.b);
}

ARat ARat_div(ARat r, ARat s)
{
	r = ARat_irreducible(r);
	s = ARat_irreducible(s);
	if (s.a > 0) {
		return ARat_mul(r, ARat_new(s.b, s.a));
	} else {
		return ARat_mul(r, ARat_new(- s.b, - s.a));
	}
}

int ARat_equ(ARat r, ARat s)
{
	ARat t = ARat_sub(r, s);
	return t.a == 0;
}

ARat ARat_next(ARat r)
{
	if (r.a == 0) {
		r.a = r.b = 1;
		goto fin;
	}
	r.a = - r.a;
	if (r.a < 0) goto fin;
retry:
	r.a++;
	r.b--;
	if (r.b == 0) {
		r.b = r.a;
		r.a = 1;
		goto fin;
	}
	if (aGcd(r.a, r.b) > 1) goto retry;
fin:
	return r;
}
