
AClass(AMemTbl) {
	const char *cNam;
	void *(*dein)(void *, AInt);	// w,lv
	void *(*free)(void *, AInt, void *);	// w, sz, p
	void *(*malloc)(void *, AInt);	// w, sz
	void *(*realloc)(void *, AInt, void *, AInt);	// w, sz0, p, sz1
};

AClass(AMemCom) {
	AMemTbl *tbl;
	AInt total, n;
};

AClass(AMem0) {
	AMemCom mc;
	// ̃NXdein̎free@\Ȃ.
	// ŉwɎg邱Ƃz肵Ă̂ŁAK͂̑傫ȃfobO@\͑z肵Ȃ(KvȂ̃Cł).
};

AStatic void *AMem0_free(AMem0 *w, AInt s, void *p)
{
	(void) w;
	(void) s;
	#if (ADbgLv >= 2)
		w->mc.total -= s;
		w->mc.n--;
	#endif
	#if (ADbgLv >= 3)
		memset(p, 0, s);
	#endif
	free(p);
	return p;
}

AStatic void *AMem0_malloc(AMem0 *w, AInt s)
{
	(void) w;
	#if (ADbgLv >= 2)
		w->mc.total += s;
		w->mc.n++;
	#endif
	void *p = malloc(s);
	#if (ADbgLv >= 2)
		if (p == 0)
			aErrExit("AMem0_malloc: out of memory");
	#endif
	#if (ADbgLv >= 3)
		memset(p, 0xa5, s);
	#endif
	return p;
}

AStatic void *AMem0_realloc(AMem0 *w, AInt s0, void *p, AInt s1)
{
	(void) w;
	(void) s0;
	#if (ADbgLv >= 2)
		w->mc.total += s1 - s0;
	#endif
	p = realloc(p, s1);
	#if (ADbgLv >= 2)
		if (p == 0)
			aErrExit("AMem0_realloc: out of memory");
	#endif
	return p;
}

AStatic void *AMem0_dein(AMem0 *w, AInt lv)
{
	(void) lv;
	return w;
}

AStatic void AMem0_init(AMem0 *w)
{
	static AMemTbl tbl[1] = {{
		"AMem0",
		ACVP &AMem0_dein,
		ACVP &AMem0_free,
		ACVP &AMem0_malloc,
		ACVP &AMem0_realloc
	}};
	w->mc.tbl = tbl;
	#if (ADbgLv >= 2)
		w->mc.total = w->mc.n = 0;
	#endif
}

////

AStatic AInt AMem_getTotal(AMemCom *w)
{
	(void) w;
	#if (ADbgLv >= 2)
		return w->total;
	#endif
	return 0;
}

AStatic AInt AMem_getN(AMemCom *w)
{
	(void) w;
	#if (ADbgLv >= 2)
		return w->n;
	#endif
	return 0;
}

AStatic const char *AMem_getCNam(AMemCom *w)
{
	return w->tbl->cNam;
}

AStatic void *AMem_dein(AMemCom *w, AInt lv)
{
	return w->tbl->dein(w, lv);
}

AStatic void *AMem_free(AMemCom *w, AInt sz, void *p)
{
	return w->tbl->free(w, sz, p);
}

AStatic void *AMem_malloc(AMemCom *w, AInt sz)
{
	return w->tbl->malloc(w, sz);
}

AStatic void *AMem_realloc(AMemCom *w, AInt sz0, void *p, AInt sz1)
{
	return w->tbl->realloc(w, sz0, p, sz1);
}


////


