#if (!defined(_WIN32_WINNT))
	#define _WIN32_WINNT 0x0500
#endif
#include <windows.h>

AClass(AWin) {
	AComArg *ca;
	void *mem;
	char title[256];
	AInt16 xsiz, ysiz;
	AInt32a *buf;
	AInt table_i;
	#if (AWinKey_BufSiz > 0)
		AInt32a keyBuf[AWinKey_BufSiz];
		AInt kbw, kbr;
		AInt32 inkeyPrm[4];
	#endif
	#if (!defined(ANoUse_LeapFlush))
		AInt32 lastFlush;
	#endif
	AInt8 phase, mode, autoClose, reqClose, keyLv, mosLv;
	AInt16 cbxs, cbys, savXy[2 * 16];
	AInt32a *cb, *savBuf;
	AInt32 pal[16];
	AInt8 optDef;
	HWND win;
	HINSTANCE hInst;
	BITMAPINFO bmi;
};

HWND aWinTable_h[AMaxWin];
AWin *aWinTable_w[AMaxWin + 1];

AStatic void AWin_initSub(AComArg *aCA, AWin *w, AInt16 xsiz, AInt16 ysiz, const char *title);

#if (ADbgLv >= 2)
	AStatic void AWin_dbgTest(AWin *w, const char *msg);
#else
	#define	AWin_dbgTest(w, msg)
#endif

AStatic void ACA_wait0(AComArg *aCA, AInt ms);	// IɌĂяoȂ΂Ȃ.

static LRESULT CALLBACK aWndProc(HWND hw, unsigned int msg, WPARAM wp, LPARAM lp);

static int aWinthread(AWin *w)
{
	WNDCLASSEX wc;
	RECT r;
	int i, x, y;
	MSG msg;

	x = w->xsiz;
	y = w->ysiz;

	wc.cbSize = sizeof (WNDCLASSEX);
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = aWndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = w->hInst;
	wc.hIcon = (HICON) LoadImage(NULL, MAKEINTRESOURCE(IDI_APPLICATION),
		IMAGE_ICON, 0, 0, LR_DEFAULTSIZE | LR_SHARED);
	wc.hIconSm = wc.hIcon;
	wc.hCursor = (HCURSOR)LoadImage(NULL, MAKEINTRESOURCE(IDC_ARROW),
		IMAGE_CURSOR, 0, 0, LR_DEFAULTSIZE | LR_SHARED);
	wc.hbrBackground = (HBRUSH) COLOR_APPWORKSPACE;
	wc.lpszMenuName = NULL;
	wc.lpszClassName = w->title;
	if (RegisterClassEx(&wc) == 0)
		return 1;
	r.left = 0;
	r.top = 0;
	r.right = x;
	r.bottom = y;
	AdjustWindowRect(&r, WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME & ~WS_MAXIMIZEBOX, FALSE);
	x = r.right - r.left;
	y = r.bottom - r.top;

	w->win = CreateWindowA(wc.lpszClassName, w->title, WS_OVERLAPPEDWINDOW & ~WS_THICKFRAME & ~WS_MAXIMIZEBOX,
		CW_USEDEFAULT, CW_USEDEFAULT, x, y, NULL, NULL,	w->hInst, NULL);
	if (w->win == NULL)
		return 1;
	aWinTable_h[w->table_i] = w->win;
	ShowWindow(w->win, SW_SHOW);
	UpdateWindow(w->win);

	for (;;) {
		i = GetMessage(&msg, NULL, 0, 0);
		if (i == 0 || i == -1)	/* G[͏IbZ[W */
			break;
		/* ̂ق͂Ƃ肠ftHg */
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	// ̃^C~OfreeĂ͂Ȃ.
	UnregisterClass(w->title, w->hInst);
	w->phase = 2;
	return 0;
}

AStatic AWin *AWin_initCa(AComArg *aCA, AWin *w, AInt16 x, AInt16 y, const char *t)
{
	AWin_initSub(aCA, w, x, y, t);
	w->bmi.bmiHeader.biSize = sizeof (BITMAPINFOHEADER);
	w->bmi.bmiHeader.biWidth = x;
	w->bmi.bmiHeader.biHeight = - y;
	w->bmi.bmiHeader.biPlanes = 1;
	w->bmi.bmiHeader.biBitCount = 32;
	w->bmi.bmiHeader.biCompression = BI_RGB;
	int i;
	CreateThread(NULL, 0, (void *) &aWinthread, (void *) w, 0, (void *) &i);
	aWinTable_h[w->table_i] = w->win;
	ACA_wait0(aCA, 128);
	return w;
}

#define AWin_open(x, y, t)	AWin_openCa(aCA, x, y, t)
AStatic AWin *AWin_openCa(AComArg *aCA, AInt16 x, AInt16 y, const char *t)
{
	AWin *w = AMem_malloc(aCA->mem, aSizeof (AWin));
	return AWin_initCa(aCA, w, x, y, t);
}

AInlineStatic AInt AWin_isClose(AWin *w) { return w->phase == 2; }

AStatic void AWin_close(AWin *w)
{
	if (w->phase != 2) {
		w->autoClose = 1;
		PostMessageA(w->win, WM_CLOSE, 0, 0);
//		DestroyWindow(w->win);
		while (w->phase != 2)
			Sleep(128);
	}
	int i;
	for (i = 0; i < 10; i++)
		Sleep(100);
	// ̂dein.
}

AStatic void AWin_dein(AWin *w)
{
	AWin_close(w);
	AMem_free(w->mem, w->xsiz * w->ysiz * aSizeof (AInt32), w->buf);
	if (w->cb != 0) { }
	if (w->savBuf != 0) { }
	// ĂȂA蔲.
}

AStatic void AWin_flushAll0(AWin *w)
{
	AWin_dbgTest(w, "AWin_flushAll0");
	if (w->phase <= 1 && w->win != 0) {
		InvalidateRect(w->win, NULL, FALSE);
		UpdateWindow(w->win);
	}
	#if (!defined(ANoUse_LeapFlush))
		if (CLOCKS_PER_SEC != 1000)
			w->lastFlush = clock() * 1000 / CLOCKS_PER_SEC;
		else
			w->lastFlush = clock();
	#endif
}

AStatic void AWin_flushAll(AWin *w)
{
	if (w != 0 && w->win != 0) {
		ACA_wait0(w->ca, 0);
		AWin_flushAll0(w);
	} else {
		ACA_wait0(0, 0); // ǂca͎gȂ̂Ŏ蔲({ȂACA_getComArg()g).
		int i;
		for (i = 0; i < AMaxWin; i++) {
			if (aWinTable_w[i] != 0 && aWinTable_h[i] != 0)
				AWin_flushAll0(aWinTable_w[i]);
		}
	}
}

#if (!defined(ANoUse_LeapFlush))

AStatic void AWin_leapFlushAll0(AWin *w, AInt32 ms)
{
	AInt32 t;
	if (CLOCKS_PER_SEC != 1000)
		t = clock() * 1000 / CLOCKS_PER_SEC;
	else
		t = clock();
	if (t - w->lastFlush >= ms) {
		ACA_wait0(w->ca, 0);
		AWin_flushAll0(w);
	}
}

AStatic void AWin_leapFlushAll(AWin *w, AInt32 ms)
{
	if (w != 0 && w->win != 0) {
		AWin_leapFlushAll0(w, ms);
	} else {
		int i;
		for (i = 0; i < AMaxWin; i++) {
			if (aWinTable_w[i] != 0 && aWinTable_h[i] != 0)
				AWin_leapFlushAll0(aWinTable_w[i], ms);
		}
	}
}

#endif

AStatic void AWin_putKeyBuf(AWin *w, AInt32 c);
AStatic AInt AWin_getSpcKeyBuf(AWin *w);

AStatic AWin *aGetWinFromWId(HWND hw)
{
	int j;
	for (j = 0; j < AMaxWin; j++) {
		if (aWinTable_h[j] == hw)
			break;
	}
	if (j >= AMaxWin)
		return 0;
	return aWinTable_w[j];
}

static LRESULT CALLBACK aWndProc(HWND hw, unsigned int msg, WPARAM wp, LPARAM lp)
{
	AWin *w = aGetWinFromWId(hw);
//	int i, j;
//	int i;
	if (w == 0)
		return DefWindowProc(hw, msg, wp, lp);
	if (msg == WM_PAINT) {
		PAINTSTRUCT ps;
		HDC hdc = BeginPaint(hw, &ps);
		SetDIBitsToDevice(hdc, 0, 0, w->xsiz, w->ysiz,
			0, 0, 0, w->ysiz, w->buf, &w->bmi, DIB_RGB_COLORS);
		EndPaint(hw, &ps);
		return 0;
	}
	if (msg == WM_CLOSE && w->autoClose == 0)
		return 0;
	if (msg == WM_DESTROY) {
		PostQuitMessage(0); // ȂƃXbhIȂ.
		return 0;
	}
#if (AWinKey_BufSiz > 0)
#if (!defined(ANoUse_Key))
	if (msg == WM_KEYDOWN || msg == WM_SYSKEYDOWN) {
		int i = -1;
		if (wp == VK_RETURN)	i = AWinKey_Enter;
		if (wp == VK_ESCAPE)	i = AWinKey_Esc;
		if (wp == VK_BACK)		i = AWinKey_BackSpace;
		if (wp == VK_TAB)		i = AWinKey_Tab;
		if (wp == VK_PRIOR)		i = AWinKey_PageUp;
		if (wp == VK_NEXT)		i = AWinKey_PageDwn;
		if (wp == VK_END)		i = AWinKey_End;
		if (wp == VK_HOME)		i = AWinKey_Home;
		if (wp == VK_LEFT)		i = AWinKey_Left;
		if (wp == VK_RIGHT)		i = AWinKey_Right;
		if (wp == VK_UP)		i = AWinKey_Up;
		if (wp == VK_DOWN)		i = AWinKey_Down;
		if (wp == VK_INSERT)	i = AWinKey_Ins;
		if (wp == VK_DELETE)	i = AWinKey_Del;
//		j = getKeyState1();
//		if (j != 0 && ' ' <= wp && wp <= 0x7e)
//			i = wp;	// CtrlAltƉĂꍇ́Aput.
//		i |= getKeyState0();
//		if ((w->keyMode & 0xf0) >= bla_MOUSE_LV1)
//			i |= getMouseState0();
		if (i != -1) {
			if (w->keyLv >= 1)
				AWin_putKeyBuf(w, i /* | j */);
			return 0;
		}
	}
	if (msg == WM_CHAR) {
		if (' ' <= wp && wp <= 0x7e) {
	//		i = wp | getKeyState0();
			int i = wp;
	//		j = getKeyState1();
	//		if ((w->keyMode & 0xf0) >= bla_MOUSE_LV1)
	//			i |= getMouseState0();
			if (w->keyLv >= 1)
				AWin_putKeyBuf(w, i /* | j */);
			return 0;
		}
	}
#endif
#if (!defined(ANoUse_Mouse))
	if (msg == WM_LBUTTONDOWN || msg == WM_RBUTTONDOWN || msg == WM_MBUTTONDOWN) {
		if (w->mosLv >= 1 && AWin_getSpcKeyBuf(w) >= 2) {
			int i = -1;
			if (msg == WM_LBUTTONDOWN) i = 0;
			if (msg == WM_RBUTTONDOWN) i = 1;
			if (msg == WM_MBUTTONDOWN) i = 2;
			if (i >= 0) {
				AWin_putKeyBuf(w, 0x4000 | i);
				AWin_putKeyBuf(w, (LOWORD(lp) & 0xffff) | (HIWORD(lp) & 0xffff) << 16);
			}
		}
	}
#endif
#endif
	return DefWindowProc(hw, msg, wp, lp);
}

AStatic void ACA_wait0(AComArg *aCA, AInt32 msec)
{
	(void) aCA;
	if (msec == 0) Sleep(0);
	do {
		if (msec < 0)
			Sleep(64);
		if (msec > 0) {
			if (msec >= 64) {
				Sleep(64);
				msec -= 64;
			} else {
				Sleep(msec);
				msec = 0;
			}
		}
//		if (aAutoQuit > 0 && aAliveWin() == 0)
//			aExitInt(aWait_exitCode);
	} while (msec != 0);
}

