typedef HWND ARpa_Win;

AClass(ARpa) {
	AInt mosPosX, mosPosY;
	AInt screenX, screenY;
	AInt x, y; // ereturnl.
	ARpa_Win *aryWin;
	AInt i, i1, inpLen, flags;
	HBITMAP hBitmap;
	INPUT inp[4096];
};

void ARpa_init(ARpa *w)
{
	w->screenX = GetSystemMetrics(SM_CXSCREEN);
	w->screenY = GetSystemMetrics(SM_CYSCREEN);
	w->inpLen = 0;
	w->flags = 0;
}

ARpa *ARpa_getMosPos(ARpa *w)
{
	POINT point;
	GetCursorPos(&point);
	w->x = point.x;
	w->y = point.y;
	return w;
}

void ARpa_setMosPos(ARpa *w, AInt x, AInt y)
{
	(void) w;
	SetCursorPos(x, y);
}

BOOL CALLBACK ARpa_getWinSub(HWND hwnd, LPARAM lParam)
{
	ARpa *w = (ARpa *) lParam;
	w->aryWin[w->i++] = hwnd;
	if (w->i >= w->i1) return FALSE;
	return TRUE;
}

AInt ARpa_getWin(ARpa *w, ARpa_Win *aryWin, AInt i1, ARpa_Win win)
{
	w->aryWin = aryWin;
	w->i1 = i1;
	w->i = 0;
	EnumChildWindows(win, ARpa_getWinSub, (LPARAM) w);
	return w->i;
}

ARpa *ARpa_getWinPos(ARpa *w, ARpa_Win win)
{
	RECT r[1];
	GetWindowRect(win, r);
	w->x = r->left;
	w->y = r->top;
	return w;
}

ARpa *ARpa_getWinSiz(ARpa *w, ARpa_Win win)
{
	RECT r[1];
	GetWindowRect(win, r);
	w->x = r->right - r->left;
	w->y = r->bottom - r->top;
	return w;
}

char *ARpa_getWinNam(ARpa *w, ARpa_Win win, char *s, AInt n)
{
	(void) w;
	char buf[10000];
	GetWindowText(win, buf, 10000 - 1);
	AInt l = strlen(buf);	// strncpyn-l傫ƂɒxȂ.
	if (l >= n) { l = n - 1; }
	memcpy(s, buf, l);
	s[l] = 0;
	return s;
}

void ARpa_setWinPos(ARpa *w, ARpa_Win win, AInt x, AInt y)
{
	(void) w;
	SetWindowPos(win, 0, x, y, 0, 0, SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);
}

void ARpa_setWinSiz(ARpa *w, ARpa_Win win, AInt x, AInt y)
{
	(void) w;
	SetWindowPos(win, 0, 0, 0, x, y, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER);
}

void ARpa_activeWin(ARpa *w, ARpa_Win win)
{
	(void) w;
	SetForegroundWindow(win);
}

ARpa_Win ARpa_srchWinNam(ARpa *w, const char *s, ARpa_Win win0)
{
	ARpa_Win win[10000];
	char buf[10000];
	AInt i, i1 = ARpa_getWin(w, win, 10000, win0);
	for (i = 0; i < i1; i++) {
		ARpa_getWinNam(w, win[i], buf, sizeof buf);
		if (strstr(buf, s) != 0) return win[i];
	}
	return 0;
}

AInt ARpa_srchWinNamCnt(ARpa *w, const char *s, ARpa_Win win0)
{
	ARpa_Win win[10000];
	char buf[10000];
	AInt i, i1 = ARpa_getWin(w, win, 10000, win0), c = 0;
	for (i = 0; i < i1; i++) {
		ARpa_getWinNam(w, win[i], buf, sizeof buf);
		if (strstr(buf, s) != 0) c++;
	}
	return c;
}

#if 0

BOOL CALLBACK ARpa_printAllWinInfoSub0(HWND hwnd, LPARAM lParam)
{
	ARpa *w = (ARpa *) lParam;
	w->hwnd[w->i1++] = hwnd;
	return TRUE;
}

BOOL CALLBACK ARpa_printAllWinInfoSub1(HWND hwnd, LPARAM lParam)
{
	(void) lParam;
	char buf[1000];
	RECT r[1];
	GetWindowText(hwnd, buf, 1000 - 1);
	GetWindowRect(hwnd, r);
	printf("  %08x (%04d %04d) (%04d %04d) '%s'\n", (AInt) hwnd, r->left, r->top, r->right - r->left, r->bottom - r->top, buf);
	return TRUE;
}

void ARpa_printAllWinInfo(ARpa *w)
{
	HWND t[10000];
	w->hwnd = t;
	w->i1 = 0;
	EnumChildWindows(0, ARpa_printAllWinInfoSub0, (LPARAM) w);
	AInt i;
	for (i = 0; i < w->i1; i++) {
		char buf[1000];
		RECT r[1];
		GetWindowText(w->hwnd[i], buf, 1000 - 1);
		GetWindowRect(w->hwnd[i], r);
		printf("%08x (%04d %04d) (%04d %04d) '%s'\n", (AInt) w->hwnd[i], r->left, r->top, r->right - r->left, r->bottom - r->top, buf);
		EnumChildWindows(w->hwnd[i], ARpa_printAllWinInfoSub1, (LPARAM) w);
	}
}

#endif

AInt32 *ARpa_capture(ARpa *w, AInt sx, AInt sy, AInt x0, AInt y0, ARpa_Win win)
{
	BITMAPINFO bmpInfo;
	ZeroMemory(&bmpInfo.bmiHeader, sizeof (BITMAPINFOHEADER));
	bmpInfo.bmiHeader.biSize = sizeof (BITMAPINFOHEADER);
	bmpInfo.bmiHeader.biWidth = sx;
	bmpInfo.bmiHeader.biHeight = - sy;
	bmpInfo.bmiHeader.biPlanes = 1;
	bmpInfo.bmiHeader.biBitCount = 32;
	bmpInfo.bmiHeader.biCompression = BI_RGB;

	AInt *lpPixel;
	HDC hdc, hMemDC;
	hdc = GetDC(win);
	hMemDC = CreateCompatibleDC(hdc);
	w->hBitmap = CreateDIBSection(hMemDC, &bmpInfo, DIB_RGB_COLORS, (void **) &lpPixel, NULL, 0);
	GdiFlush();
	HGDIOBJ old = SelectObject(hMemDC, w->hBitmap);
	BitBlt(hMemDC, 0, 0, sx, sy, hdc, x0, y0, SRCCOPY);
	SelectObject(hMemDC, old);
	DeleteDC(hMemDC);
	ReleaseDC(win, hdc);

	return lpPixel;
}

void ARpa_captureFree(ARpa *w)
{
	DeleteObject(w->hBitmap);
	GdiFlush();
}

AInt32 ARpa_getPix(ARpa *w, AInt x, AInt y, ARpa_Win win)
{
	AInt32 *b = ARpa_capture(w, 1, 1, x, y, win);
	AInt32 c = *b & 0xffffff;
	ARpa_captureFree(w);
	return c;
}

void ARpa_flushInput(ARpa *w)
{
	SendInput(w->inpLen, w->inp, sizeof (INPUT));
	w->inpLen = 0;
}

void ARpa_keyInRaw(ARpa *w, int c, int flags)
{
	INPUT *ip = &w->inp[w->inpLen];
	ip->type = INPUT_KEYBOARD;
	ip->ki.wVk = c;
	ip->ki.wScan = MapVirtualKey(c, 0);
	ip->ki.dwFlags = flags;
	ip->ki.time = 0;
	ip->ki.dwExtraInfo = 0;
	w->inpLen++;
}

void ARpa_keyIn(ARpa *w, AInt c)
/* {L[{[hp */
{
	char shift = 0;
	if (c == '\n') c = VK_RETURN;
	else if (c == ':') c = VK_OEM_1;
	else if (c == '\\') c = VK_OEM_102;
	else if (c == '/') c = VK_OEM_2;
	else if (c == '.') c = VK_OEM_PERIOD;
	else if (c == '_') { shift = 1; c = VK_OEM_102; }
	else if ('0' <= c && c <= '9') ;
	else if ('A' <= c && c <= 'Z' && (w->flags & 1) == 0) shift = 1;
	else if ('A' <= c && c <= 'Z' && (w->flags & 1) != 0) ;
	else if ('a' <= c && c <= 'z' && (w->flags & 1) == 0) { c -= 'a' - 'A'; }
	else if ('a' <= c && c <= 'z' && (w->flags & 1) != 0) { c -= 'a' - 'A'; shift = 1; }
	else if (c == '?') { shift = 1; c = VK_OEM_2; }
	else if (c == '=') { shift = 1; c = VK_OEM_MINUS; }
	else if (c == '$') { shift = 1; c = '4'; }
	else if (c == '%') { shift = 1; c = '5'; }
	else if (c == '&') { shift = 1; c = '6'; }
	else if (c == ' ') c = VK_SPACE;
	else { printf("ARpa_keyIn: error: '%c'\n", c); exit(1); }
	if (shift != 0)
		ARpa_keyInRaw(w, VK_SHIFT, 0);
	ARpa_keyInRaw(w, c, 0);
	ARpa_keyInRaw(w, c, KEYEVENTF_KEYUP);
	if (shift != 0)
		ARpa_keyInRaw(w, VK_SHIFT, KEYEVENTF_KEYUP);
}

void ARpa_keyInStr(ARpa *w, const char *s)
{
	while (*s != '\0')
		ARpa_keyIn(w, *s++);
}

void ARpa_mouseMove(ARpa *w, AInt x, AInt y)
{
	INPUT *ip = &w->inp[w->inpLen];
	ip->type = INPUT_MOUSE;
	ip->mi.dx = (x << 16) / w->screenX;
	ip->mi.dy = (y << 16) / w->screenY;
	ip->mi.dwFlags = MOUSEEVENTF_ABSOLUTE | MOUSEEVENTF_MOVE;
	ip->mi.time = 0;
	ip->mi.dwExtraInfo = 0;
	w->inpLen++;
}

void ARpa_mouseClick(ARpa *w, AInt f0, AInt f1)
{
	INPUT *ip = &w->inp[w->inpLen];
	ip->type = INPUT_MOUSE;
	ip->mi.dx = 0;
	ip->mi.dy = 0;
	ip->mi.dwFlags = f0;
	ip->mi.time = 0;
	ip->mi.dwExtraInfo = 0;
	ip++;
	w->inpLen++;
	if (f1 != -1) {
		ip->type = INPUT_MOUSE;
		ip->mi.dx = 0;
		ip->mi.dy = 0;
		ip->mi.dwFlags = f1;
		ip->mi.time = 0;
		ip->mi.dwExtraInfo = 0;
		w->inpLen++;
	}
}

void ARpa_mouseMoveClickLeftFlush(ARpa *w, AInt x, AInt y)
{
	ARpa_getMosPos(w);
	ARpa_mouseMove(w, x, y);
	ARpa_flushInput(w);
	Sleep(100);
	ARpa_mouseMove(w, x, y);
	ARpa_mouseClick(w, MOUSEEVENTF_LEFTDOWN, MOUSEEVENTF_LEFTUP);
	ARpa_flushInput(w);
	ARpa_setMosPos(w, w->x, w->y);
}

void ARpa_mouseMoveClickRightFlush(ARpa *w, AInt x, AInt y)
{
	ARpa_getMosPos(w);
	ARpa_mouseMove(w, x, y);
	ARpa_flushInput(w);
	Sleep(100);
	ARpa_mouseMove(w, x, y);
	ARpa_mouseClick(w, MOUSEEVENTF_RIGHTDOWN, MOUSEEVENTF_RIGHTUP);
	ARpa_flushInput(w);
	ARpa_setMosPos(w, w->x, w->y);
}


