#if (!defined(AStatic))
	#define AStatic static
#endif

#if (!defined(AInlineStatic))
	#define AInlineStatic inline static
#endif

#if (!defined(ADbgLv))
	#define ADbgLv	0
#endif

#define AClass(nam)	typedef struct nam ## _ nam; struct nam ## _

#if (defined(AArch_X86))
	#define AIntBit		32
	#define AIntMax		0x7fffffff
	typedef signed char AInt8;
	typedef int AInt16;
	typedef int AInt32;
	typedef long long AInt64;
	typedef unsigned char AUInt8;
	typedef int AUInt16;
	typedef unsigned int AUInt32;
	typedef unsigned long long AUInt64;
	typedef int AInt32a;
	typedef AInt32 AInt;
	typedef AUInt32 AUInt;
	typedef unsigned char AUInt8a;
#elif (defined(AArch_X64))
	#define AIntBit		64
	#define AIntMax		0x7fffffffffffffffLL
	typedef signed char AInt8;
	typedef int AInt16;
	typedef int AInt32;
	typedef long long AInt64;
	typedef unsigned char AUInt8;
	typedef int AUInt16;
	typedef unsigned int AUInt32;
	typedef unsigned long long AUInt64;
	typedef int AInt32a;
	typedef AInt64 AInt;
	typedef AUInt64 AUInt;
	typedef unsigned char AUInt8a;
#elif (defined(AArch_Arm32))
	#define AIntBit		32
	#define AIntMax		0x7fffffff
	typedef signed char AInt8;
	typedef int AInt16;
	typedef int AInt32;
	typedef long long AInt64;
	typedef unsigned char AUInt8;
	typedef int AUInt16;
	typedef unsigned int AUInt32;
	typedef unsigned long long AUInt64;
	typedef int AInt32a;
	typedef AInt32 AInt;
	typedef AUInt32 AUInt;
	typedef unsigned char AUInt8a;
#elif (defined(AArch_AArch64))
	#define AIntBit		64
	#define AIntMax		0x7fffffffffffffffLL
	typedef signed char AInt8;
	typedef int AInt16;
	typedef int AInt32;
	typedef long long AInt64;
	typedef unsigned char AUInt8;
	typedef int AUInt16;
	typedef unsigned int AUInt32;
	typedef unsigned long long AUInt64;
	typedef int AInt32a;
	typedef AInt64 AInt;
	typedef AUInt64 AUInt;
	typedef unsigned char AUInt8a;
#endif

#define aSizeof		(AInt) sizeof

#define ACat_Helper(x, y) x##y
#define ACat(x, y) ACat_Helper(x, y)
#define ACat3(x, y, z) ACat(ACat(x, y), z)
#define ACat4(a, b, c, d) ACat(ACat(a, b), ACat(c, d))
#define ACat5(a, b, c, d, e) ACat(ACat3(a, b, c), ACat(d, e))
#define ACat6(a, b, c, d, e, f) ACat(ACat3(a, b, c), ACat3(d, e, f))
#define ACat7(a, b, c, d, e, f, g) ACat(ACat4(a, b, c, d), ACat3(e, f, g))
#define ACat8(a, b, c, d, e, f, g, h) ACat(ACat4(a, b, c, d), ACat4(e, f, g, h))

#define ACVP		(void *)

AClass(AComArgCom) {
	int argc;
	const char **argv;
	#if (!defined(ANoUse_Graphics))
		AInt winClsWait;
	#endif
	AInt retValInt[16];
	double retValDbl[16];
};

AClass(AComArg) {
	void *mem, *ctx, *memDbg, *ctxDbg;
	AComArgCom *com;
};

AStatic AComArg *ACA_p;	// {͂16炢͂. XbhƂɕʂɂȂĂ.

AStatic AComArg *ACA_set(AComArg *aCA)
{
	return ACA_p = aCA;
}

AStatic AComArg *ACA_getComArg()
{
	return ACA_p;
}

#define AWinMode_Set		0
#define AWinMode_Or		1
#define AWinMode_And		2
#define AWinMode_Xor		3

#define AWinKey_Enter		10
#define AWinKey_Esc		27
#define AWinKey_BackSpace	8
#define AWinKey_Tab		9
#define AWinKey_PageUp		0x1020
#define AWinKey_PageDwn	0x1021
#define	AWinKey_End		0x1022
#define	AWinKey_Home		0x1023
#define AWinKey_Left		0x1024
#define AWinKey_Right		0x1025
#define AWinKey_Up			0x1026
#define AWinKey_Down		0x1027
#define AWinKey_Ins		0x1028
#define AWinKey_Del		0x1029

#define AWinKey_Locks		0x00f00000

#define AWinKey_Lv0		0x00
#define AWinKey_Lv1		0x01
#define AWinMos_Lv0		0x00
#define AWinMos_Lv1		0x10	// NbN̂.
#define AWinMos_Lv2		0x20	// MOVEׂ.
#define AWinMos_Lv3		0x30	// zC[.

#define AArySet2(a, v0, v1)		(a)[0] = (v0); (a)[1] = (v1)
#define AArySet3(a, v0, v1, v2)		(a)[0] = (v0); (a)[1] = (v1); (a)[2] = (v2)
#define AArySet4(a, v0, v1, v2, v3)		(a)[0] = (v0); (a)[1] = (v1); (a)[2] = (v2); (a)[3] = (v3)
#define AArySet5(a, v0, v1, v2, v3, v4)		(a)[0] = (v0); (a)[1] = (v1); (a)[2] = (v2); (a)[3] = (v3); (a)[4] = (v4)
#define AArySet6(a, v0, v1, v2, v3, v4, v5)		(a)[0] = (v0); (a)[1] = (v1); (a)[2] = (v2); (a)[3] = (v3); (a)[4] = (v4); (a)[5] = (v5)
#define AArySet7(a, v0, v1, v2, v3, v4, v5, v6)		(a)[0] = (v0); (a)[1] = (v1); (a)[2] = (v2); (a)[3] = (v3); (a)[4] = (v4); (a)[5] = (v5); (a)[6] = (v6)
#define AArySet8(a, v0, v1, v2, v3, v4, v5, v6, v7)		(a)[0] = (v0); (a)[1] = (v1); (a)[2] = (v2); (a)[3] = (v3); (a)[4] = (v4); (a)[5] = (v5); (a)[6] = (v6); (a)[7] = (v7)

#define AArySet2ip(a, i, v0, v1)		AArySet2((a) + (i), v0, v1); i += 2
#define AArySet3ip(a, i, v0, v1, v2)		AArySet3((a) + (i), v0, v1, v2); i += 3
#define AArySet4ip(a, i, v0, v1, v2, v3)		AArySet4((a) + (i), v0, v1, v2, v3); i += 4
#define AArySet5ip(a, i, v0, v1, v2, v3, v4)		AArySet5((a) + (i), v0, v1, v2, v3, v4); i += 5
#define AArySet6ip(a, i, v0, v1, v2, v3, v4, v5)		AArySet6((a) + (i), v0, v1, v2, v3, v4, v5); i += 6
#define AArySet7ip(a, i, v0, v1, v2, v3, v4, v5, v6)		AArySet7((a) + (i), v0, v1, v2, v3, v4, v5, v6); i += 7
#define AArySet8ip(a, i, v0, v1, v2, v3, v4, v5, v6, v7)		AArySet8((a) + (i), v0, v1, v2, v3, v4, v5, v6, v7); i += 8























#if 0

#define ASTRINGIFY(n) #n
#define ATOSTRING(n) ASTRINGIFY(n)
#define ASRCPOS __FILE__ ":" ATOSTRING(__LINE__) ": "

// SetDbgSrcPosComma
#if (defined(ADEBUG))
	#define ASDSPC	aDbgSrcPos = ASRCPOS,
#else
	#define ASDSPC
#endif

#if (!defined(ANOUSE_ARG))
	ASTATIC int aArgc;
	ASTATIC char **aArgv;
#endif

#if (!defined(ANOUSE_ATERRMSG))
	static char *aAtErrExitMsg;
#endif

AStatic void aErrExit(const char *f, ...);
AStatic void *aErrExitP0(void *p, const char *f, ...);

ADefCls(ASP) {	// size and pointer, simple.
	AInt s1, s;
	char *p;
	struct AMemAlc1_ *ma1;
};

ADefCls(AClean) {
	ASP sp;
	AInt lnk;
	struct AClean_ *pr, *ch;
	void *ext;
};

ADefCls0(AComArg) {
	AClean *tc;
	struct AMemAlc1_ *ta, *na;
	struct AComArg_ *d, *s;
	struct AComArg_Dbg_ *dbg;
	void *ext;
};

#define ACA		AComArg *ca0

ASTATIC void *aMalloc(ACA, AInt sz, AClean *c);
ASTATIC void aFree(ACA, void *p, AInt sz);
ASTATIC void *aMallocTmp(ACA, AInt sz, AClean *c);
ASTATIC void aFreeTmp(ACA, void *p, AInt sz);

void aMain(ACA);

#endif
