#include "stdlibs.c"
#include "acl0.c"
#include "mem.c"

#if (!defined(ANoUse_Graphics))
	#if (!defined(AMaxWin))
		#define AMaxWin	16
	#endif
	#if (!defined(AWinKey_BufSiz))
		#define AWinKey_BufSiz		1024
	#endif
	#if (defined(AGraph_Win))
		#include "win.c"
	#elif (defined(AGraph_SDL2)
		#include "sdl2.c"
	#endif
	#include "chr.c"
	#include "graphics.c"
#endif

#include "play.c"

AStatic void ACA_waitForExit(AComArg *aCA)
{
	if (AAutoPlay_p != 0)
		APlay_run(AAutoPlay_p);
	#if (!defined(ANoUse_Graphics))
		AWin_flushAll(0);
		while (aCA->com->winClsWait < aAliveWin())
			ACA_wait0(aCA, 64);
	#endif
}

AStatic LONG WINAPI aExceptionHandler(struct _EXCEPTION_POINTERS *ExceptionInfo)
{
    char *s = "unknown";
    DWORD c = ExceptionInfo->ExceptionRecord->ExceptionCode;
    if (c == EXCEPTION_ACCESS_VIOLATION)       s = "EXCEPTION_ACCESS_VIOLATION"; // NULL pointer Ȃ.
    if (c == EXCEPTION_GUARD_PAGE)             s = "EXCEPTION_GUARD_PAGE";
    if (c == EXCEPTION_ILLEGAL_INSTRUCTION)    s = "EXCEPTION_ILLEGAL_INSTRUCTION";
    if (c == EXCEPTION_IN_PAGE_ERROR)          s = "EXCEPTION_IN_PAGE_ERROR";
    if (c == EXCEPTION_INT_DIVIDE_BY_ZERO)     s = "EXCEPTION_INT_DIVIDE_BY_ZERO";
    if (c == EXCEPTION_PRIV_INSTRUCTION)       s = "EXCEPTION_PRIV_INSTRUCTION";
    fprintf(stderr, "aExceptionHandler: addr=%08x, code=%s(%08x), flags=%08x\n",
        (int) ExceptionInfo->ExceptionRecord->ExceptionAddress,
        s,
        (int) ExceptionInfo->ExceptionRecord->ExceptionCode,
        (int) ExceptionInfo->ExceptionRecord->ExceptionFlags
    );
    int i, n = ExceptionInfo->ExceptionRecord->NumberParameters;
    fprintf(stderr, "  ExceptionInformation: n=%d", n);
    for (i = 0; i < n; i++)
        fprintf(stderr, ", %08x", (int) ExceptionInfo->ExceptionRecord->ExceptionInformation[i]);
    fprintf(stderr, "\n");
    return EXCEPTION_EXECUTE_HANDLER; // Ԃ΂ɏIĂ.
}

AClass(AVec3) { double x, y, z; };
AVec3  AVec3_new(double x, double y, double z) { AVec3 v = { x, y, z }; return v; }
AVec3  AVec3_add(AVec3 a, AVec3 b)  { return AVec3_new(a.x + b.x, a.y + b.y, a.z + b.z); }
AVec3  AVec3_sub(AVec3 a, AVec3 b)  { return AVec3_new(a.x - b.x, a.y - b.y, a.z - b.z); }
AVec3  AVec3_mul(double t, AVec3 v) { return AVec3_new(t * v.x,   t * v.y,   t * v.z);   }
double AVec3_dot(AVec3 a, AVec3 b)  { return a.x * b.x + a.y * b.y + a.z * b.z;        }
double AVec3_length(AVec3 v)        { return sqrt(AVec3_dot(v, v));                      }

AVec3 AVec3_normalize(AVec3 v)
{
	double len = AVec3_length(v);
	if (len > 1.0e-50)
		v = AVec3_mul(1.0 / len, v);
	return v;
}

AClass(AMat33) { double xx, xy, xz, yx, yy, yz, zx, zy, zz; };

AVec3 AMat33Vec3_mul(AMat33 m, AVec3 v)
{
	AVec3 w;
	w.x = m.xx * v.x + m.xy * v.y + m.xz * v.z;
	w.y = m.yx * v.x + m.yy * v.y + m.yz * v.z;
	w.z = m.zx * v.x + m.zy * v.y + m.zz * v.z;
	return w;
}

AMat33 AMat33_mul(AMat33 a, AMat33 b) {
	AMat33 m;
	m.xx = a.xx * b.xx + a.xy * b.yx + a.xz * b.zx;
	m.xy = a.xx * b.xy + a.xy * b.yy + a.xz * b.zy;
	m.xz = a.xx * b.xz + a.xy * b.yz + a.xz * b.zz;
	m.yx = a.yx * b.xx + a.yy * b.yx + a.yz * b.zx;
	m.yy = a.yx * b.xy + a.yy * b.yy + a.yz * b.zy;
	m.yz = a.yx * b.xz + a.yy * b.yz + a.yz * b.zz;
	m.zx = a.zx * b.xx + a.zy * b.yx + a.zz * b.zx;
	m.zy = a.zx * b.xy + a.zy * b.yy + a.zz * b.zy;
	m.zz = a.zx * b.xz + a.zy * b.yz + a.zz * b.zz;
	return m; }

AMat33 AMat33_rotX(double t) {
	AMat33 m;
	double c = cos(t), s = sin(t);
	m.xx = 1;
	m.xy = 0;
	m.xz = 0;
	m.yx = 0;
	m.yy =   c;
	m.yz = - s;
	m.zx = 0;
	m.zy =   s;
	m.zz =   c;
	return m; }

AMat33 AMat33_rotY(double t) {
	AMat33 m;
	double c = cos(t), s = sin(t);
	m.xx =   c;
	m.xy = 0;
	m.xz =   s;
	m.yx = 0;
	m.yy = 1;
	m.yz = 0;
	m.zx = - s;
	m.zy = 0;
	m.zz =   c;
	return m; }

AMat33 AMat33_rotZ(double t) {
	AMat33 m;
	double c = cos(t), s = sin(t);
	m.xx =   c;
	m.xy = - s;
	m.xz = 0;
	m.yx =   s;
	m.yy =   c;
	m.yz = 0;
	m.zx = 0;
	m.zy = 0;
	m.zz = 1;
	return m; }


AMat33 AMat33_eulerAnglesXyz(double a, double b, double c) {
	return AMat33_mul(AMat33_rotZ(c), AMat33_mul(AMat33_rotY(b), AMat33_rotX(a))); }
    // Ql: https://programming-surgeon.com/script/euler-angle/




double aSaturateDbl(double x, double x0, double x1)
{
	if (x < x0) x = x0;
	if (x > x1) x = x1;
	return x;
}

AInlineStatic AInt aMul64Shr(AInt i, AInt j, AInt k)
{
	return ((long long) i) * ((long long) j) >> k;
}

AInlineStatic void aPrintTime()
{
	printf("time: %.3f[sec]\n", clock() / (double) CLOCKS_PER_SEC);
}

AInlineStatic AInt aFf16Sin(AInt x)
{
	return (AInt) (sin(x * (2 * 3.14159265358979323 / 65536)) * 65536);
}

AInlineStatic AInt aFf16Cos(AInt x)
{
	return (AInt) (cos(x * (2 * 3.14159265358979323 / 65536)) * 65536);
}

AInlineStatic AInt aFf16Sqrt(AInt x)
{
	return (AInt) (sqrt(x * (1.0 / 65536)) * 65536);
}

#if (!defined(ANoUse_Xorshift32))

static AUInt32 aXorShift32_i = 2463534242U;

AStatic void aXorShift32_seed(AUInt32 s)
{
	aXorShift32_i = 2463534242U ^ s;
}

AStatic AUInt32 aXorShift32()
{
	AUInt32 i = aXorShift32_i;
	i = i ^ (i << 13);
	i = i ^ (i >> 17);
	i = i ^ (i <<  5);
	aXorShift32_i = i;
	return i;
}

#endif

AInt aRepC;
#define ARep(n) for (aRepC = 0; aRepC < n; aRepC++)
#define ARep0(n, i)	for (i = 0; i < n; i++)

AStatic AInt aRnd(AInt32 n)
{
	return aXorShift32() % n;
}

#define aArgMaxRndInt(a, i0, i1)	ACA_argMaxRndInt(aCA, a, i0, i1)
AStatic AInt ACA_argMaxRndInt(AComArg *aCA, AInt *a, AInt i0, AInt i1)
{
	if (i0 >= i1) return i0;
	char *b = AMem_malloc(aCA->mem, i1 - i0);
	AInt max = a[i0], i, i00 = i0, s = 0;
	memset(b, 0, i1 - i0);
	for (i = i0; i < i1; i++) {
		if (max < a[i]) {
			max = a[i];
			i00 = i;
		}
		b[i - i0] = (a[i] == max);
	}
	for (i = i00; i < i1; i++)
		s += b[i - i0];
	s = aRnd(s);
	for (i = i00; i < i1; i++) {
		if (b[i - i0] == 0) continue;
		if (s == 0) break;
		s--;
	}
	AMem_free(aCA->mem, i1 - i0, b);
	return i;
}

AStatic AInt aArgMaxFstInt(AInt *a, AInt i0, AInt i1)
{
	if (i0 >= i1) return i0;
	AInt max = a[i0], i, j = i0;
	for (i = i0; i < i1; i++) {
		if (max < a[i]) {
			max = a[i];
			j = i;
		}
	}
	return j;
}

AStatic AInt aArgMaxLstInt(AInt *a, AInt i0, AInt i1)
{
	if (i0 >= i1) return i0;
	AInt max = a[i0], i, j = i0;
	for (i = i0; i < i1; i++) {
		if (max <= a[i]) {
			max = a[i];
			j = i;
		}
	}
	return j;
}

AStatic AInt aArgMaxLstDbl(double *a, AInt i0, AInt i1)
{
	if (i0 >= i1) return i0;
	double max = a[i0];
	AInt i, j = i0;
	for (i = i0; i < i1; i++) {
		if (max <= a[i]) {
			max = a[i];
			j = i;
		}
	}
	return j;
}

#define AUpdateMinMax(min, max, x)  if (min > x) min = x; if (max < x) max = x

AStatic double aReminder0(double a, double b) {
	double p = (AInt64) (a / b);
	return a - p * b; }

AStatic double aReminder1(double a, double b) {
	double r = aReminder0(a, b);
	if (r < 0) r += b;
	return r; }

#define ASwapTmp(a, b, t)  do { t = a; a = b; b = t; } while (0)

#define aGetArgc()	ACA_getArgc(aCA)
AInlineStatic int ACA_getArgc(AComArg *aCA) { return aCA->com->argc; }

#define aGetArgv()	ACA_getArgv(aCA)
AInlineStatic void *ACA_getArgv(AComArg *aCA) { return aCA->com->argv; } // const̗LŃG[ɂȂ߂ void * ƂĂ.




void aMain(AComArg *aCA);

int main(int argc, const char **argv)
{
//	(void) AWin_chrFontEx;
	#if (ADbgLv >= 1)
		SetUnhandledExceptionFilter(aExceptionHandler);
	#endif
	#if (!defined(ANoUse_Xorshift32))
		aXorShift32_seed(time(0));
	#endif
	AComArg aCA[1];
	AComArgCom aCAC[1];
	AMem0 mem0[1];
	aCA->mem = mem0;
	aCA->ctx = 0;
	aCA->memDbg = 0;
	aCA->com = aCAC;
	aCAC->argc = argc;
	aCAC->argv = argv;
	#if (!defined(ANoUse_Graphics))
		aCAC->winClsWait = 0;
	#endif
	AMem0_init(mem0);
	#if (ADbgLv >= 2)
		AMem0 mem0Dbg[1];
		aCA->memDbg = mem0Dbg;
		AMem0_init(mem0Dbg);
	#endif
	ACA_set(aCA);
	aMain(aCA);
	ACA_waitForExit(aCA);
	return 0;
}


#define aInput(s)	ACA_input(aCA, s)
AStatic double ACA_input(AComArg *aCA, const char *s)
{
	(void) aCA;
	double x;
	if (s != 0)
		printf("%s", s);
	scanf("%lf", &x);
	return x;
}

typedef char *AStr;

#define aInputStr()	ACA_inputStr(aCA)
AStatic AStr ACA_inputStr(AComArg *aCA)
{
	(void) aCA;
	AStr s = malloc(64 * 1024);
	scanf("%s", s);
	return realloc(s, strlen(s) + 1);
}

#define aStrcat(s, t)	ACA_strcat(aCA, s, t)
AStatic AStr ACA_strcat(AComArg *aCA, AStr s, AStr t)
{
	(void) aCA;
	AStr u = malloc(strlen(s) + strlen(t) + 1);
	sprintf(u, "%s%s", s, t);
	return u;
}

#define aSprintf(...)	ACA_sprintf(aCA, __VA_ARGS__)
AStatic AStr ACA_sprintf(AComArg *aCA, const char *s, ...)
{
	(void) aCA;
	va_list ap;
	va_start(ap, s);
	AStr t = malloc(256 * 1024);
	vsprintf(t, s, ap);
	va_end(ap);
	return realloc(t, strlen(t) + 1);
}

#define aPrintInt(i)	ACA_printInt(aCA, i)
AStatic void ACA_printInt(AComArg *aCA, AInt i)
{
	(void) aCA;
	printf("%d\n", (int) i);
}

#define aLoadFile(path, sz0, mrgn, psz, flg)	ACA_loadFile(aCA, path, sz0, mrgn, psz, flg)
AStatic char *ACA_loadFile(AComArg *aCA, const char *path, AInt sz0, AInt mrgn, AInt *psz, AInt flg)
{
	FILE *fp = fopen(path, "rb");
	if (fp == 0) {
		if ((flg & 1) != 0) {
			fprintf(stderr, "aloadFileStr: fopen error: %s\n", path);
			if ((flg & 2) != 0)
				exit(1);
		}
		*psz = -1;
		return 0;
	}
	char *b = AMem_malloc(aCA->mem, sz0 + mrgn);
	AInt i = fread(b, 1, sz0, fp);
	fclose(fp);
	if (i >= sz0) {
		if ((flg & 4) != 0) {
			fprintf(stderr, "aloadFileStr: too large file: %s\n", path);
			if ((flg & 8) != 0)
				exit(1);
		}
		i = sz0;
	}
	if ((flg & 16) == 0)
		b = AMem_realloc(aCA->mem, sz0 + mrgn, b, i + mrgn);
	*psz = i;
	if (mrgn > 0) memset(b + i, 0, mrgn);
	return b;
}

enum { ATcSemi = 1, ATcNot, ATcPerce, ATcAnd, ATcWiCard, ATcExpr, ATcExpr0, ATc0, ATcBrOpn, ATcBrCls,
	ATcSqBrOpn, ATcSqBrCls, ATcComma, ATcCrBrOpn, ATcCrBrCls, ATcOpLp2, ATcOpLp4 };
const char aTknInit[] = "; ! % & .! .% .& 0 ( ) [ ] , { } :< :<=";

AClass(AEasyC_TknMan) {
	char **tStr;
	AInt *tLen, i1, i;
	void *mem;
};

AStatic const char *AEasyC_lexer(AEasyC_TknMan *tm, const char *s, AInt *tkn, const char **q);

AStatic void AEasyC_TknMan_initCa(AComArg *aCA, AEasyC_TknMan *w, AInt i1)
{
	if (i1 <= 0) i1 = 4096;
	w->mem = aCA->mem;
	w->i1 = i1;
	w->i = 1;
	w->tStr = AMem_malloc(w->mem, i1 * sizeof (char *));
	w->tLen = AMem_malloc(w->mem, i1 * sizeof (AInt));
	w->tStr[0] = "";
	w->tLen[0] = 0;
	AInt dmy0[1000];
	const char *dmy1[1000];
	AEasyC_lexer(w, aTknInit, dmy0, dmy1);
}

AStatic void AEasyC_TknMan_dein(AEasyC_TknMan *w)
{
	AInt i;
	for (i = 1; i < w->i; i++) {
		AMem_free(w->mem, w->tLen[i] + 1, w->tStr[i]);
	}
	AMem_free(w->mem, w->i1 * sizeof (char *), w->tStr);
	AMem_free(w->mem, w->i1 * sizeof (AInt), w->tLen);
}

AStatic AInt AEasyC_TknMan_tkn(AEasyC_TknMan *w, const char *s, AInt l)
{
	if (l <= 0) l = strlen(s);
	AInt i;
	for (i = 1; i < w->i; i++) {
		if (w->tLen[i] == l && memcmp(s, w->tStr[i], l) == 0)
			return i;
	}
	if (i >= w->i1) {
		w->tStr = AMem_realloc(w->mem, w->i1 * sizeof (char *), w->tStr, w->i1 * 2 * sizeof (char *));
		w->tLen = AMem_realloc(w->mem, w->i1 * sizeof (AInt), w->tLen, w->i1 * 2 * sizeof (AInt));
		w->i1 *= 2;
	}
	w->i = i + 1;
	w->tStr[i] = AMem_malloc(w->mem, l + 1);
	memcpy(w->tStr[i], s, l);
	w->tStr[i][l] = 0;
	w->tLen[i] = l;
	return i; // w->i1AVKo^Ɣł.
}

AStatic int AEasyC_strlenLf0(const char *s)
{
	int l = 0;
	while (s[l] != 0 && s[l] != '\n')
		l++;
	return l;
}

AStatic int AEasyC_strlenLf1(const char *s)
{
	int l = AEasyC_strlenLf0(s);
	if (s[l] == '\n')
		l++;
	return l;
}

AStatic int AEasyC_isAlphabetOrNumber(unsigned char c)  // ϐɎgpł镶ǂ.
{
    if ('0' <= c && c <= '9') return 1;
    if ('a' <= c && c <= 'z') return 1;
    if ('A' <= c && c <= 'Z') return 1;
    if (c == '_') return 1;
    return 0;
}

AStatic AInt AEasyC_getTknLen(const char *s)
{
	AInt l = 0;
	if (strchr("(){}[];,", s[0]) != 0)
		return 1;
	if (AEasyC_isAlphabetOrNumber(s[0]) != 0) {  // 1ڂp.
		while (AEasyC_isAlphabetOrNumber(s[l]) != 0)
			l++;
		return l;
	}
	if (strchr("=+-*/!%&^~|<>?:.#", s[0]) != 0) {  // 1ڂʂ̋L.
		while (s[l] != 0 && strchr("=+-*/!%&^~|<>?:.#", s[l]) != 0)
			l++;
		return l;
	}
	if (s[0] == 0x22 || s[0] == 0x27) {
		l = 1;
		while (s[l] != s[0] && s[l] >= ' ')
			l++;
		if (s[l] == s[0]) l++;
		return l;
	}
	return 0; // error.
}

AStatic const char *AEasyC_lexer(AEasyC_TknMan *tm, const char *s, AInt *tkn, const char **q)
{
	if (s == 0) return 0;
	AInt pc = 0, qc = 0;
	while (s[pc] != 0) {
        if (s[pc] == ' ' || s[pc] == '\t' || s[pc] == '\n' || s[pc] == '\r') {	// Xy[XA^uAs.
            pc++;
            continue;
        }
        if (s[pc] == '/' && s[pc + 1] == '/') {
            while (s[pc] != 0 && s[pc] != '\n')
                pc++;
            continue;
        }
		if (s[pc] == '#') {
            while (s[pc] != 0 && s[pc] != '\n')
                pc++;
            continue;
        }
		AInt len = AEasyC_getTknLen(&s[pc]);
		if (len <= 0) break;
		tkn[qc] = AEasyC_TknMan_tkn(tm, &s[pc], len);
		q[qc] = &s[pc];
		pc += len;
		qc++;
	}
	tkn[qc] = 0;
	q[qc] = &s[pc];
	return &s[pc];
}

AClass(AEasyC_PhrMan) {
	void *mem;
	AInt i, i1, **tknStr;
	AEasyC_TknMan *tm;
	AInt **wpc;
};

AStatic void AEasyC_PhrMan_initCa(AComArg *aCA, AEasyC_PhrMan *w, AInt i1, AEasyC_TknMan *tm)
{
	w->mem = aCA->mem;
	w->i1 = i1;
	w->tknStr = AMem_malloc(w->mem, i1 * sizeof (AInt *));
	w->tm = tm;
	AInt i;
	for (i = 0; i < i1; i++)
		w->tknStr[i] = 0;
}

AStatic void AEasyC_PhrMan_dein(AEasyC_PhrMan *w)
{
	AInt i, j;
	for (i = 0; i < w->i1; i++) {
		if (w->tknStr[i] != 0) {
			AInt *p = w->tknStr[i];
			for (j = 0; p[j] != 0; j++);
			AMem_free(w->mem, (j + 1) * sizeof (AInt), p);
		}
	}
	AMem_free(w->mem, w->i1 * sizeof (AInt *), w->tknStr);
}

AStatic AInt AEasyC_PhrMan_phr(AEasyC_PhrMan *w, int i, const char *phrs)
{
    AInt j, k;
	AInt *s = w->wpc[0];
    AInt *t = w->tknStr[i];
    if (t == 0) { // ̌Ăяo.
		AInt tmp[1000];
		const char *dmy[10000];
		AEasyC_lexer(w->tm, phrs, tmp, dmy);
		for (j = 0; tmp[j] != 0; j++);
		t = w->tknStr[i] = AMem_malloc(w->mem, (j + 1) * sizeof (AInt));
		for (j = 0; tmp[j] != 0; j++)
			t[j] = tmp[j];
		t[j] = 0;
        if (phrs[0] != ' ') { // ȗ`𒼂.
            for (j = 0; t[j] != 0; j++) {
                if (t[j] == ATcNot)   t[j] = ATcWiCard;
                if (t[j] == ATcPerce) t[j] = ATcExpr;
                if (t[j] == ATcAnd)   t[j] = ATcExpr0;
            }
        }
    }
    for (j = 0; t[j] != 0; j++) { // r̃[v.
        if (t[j] == ATcWiCard && s[0] != 0) { // ChJ[h.
            w->wpc[strtol(w->tm->tStr[t[++j]], 0, 0)] = s++;  // ̐lǂŁAChJ[hʒuL.
        } else if (t[j] == ATcExpr || t[j] == ATcExpr0) { // .
			AInt jj = strtol(w->tm->tStr[t[++j]], 0, 0);
            w->wpc[jj] = s;  // ̐lǂŁAʒuL.
            for (k = 0; ; s++) {
                if (s[0] == ATcSemi) break;
                if (s[0] == ATcComma && k == 0) break;
                if (s[0] == t[j + 1] && k == 0) break;
                if (s[0] == ATcBrOpn || s[0] == ATcSqBrOpn) k++; // 蔲.
                if (s[0] == ATcBrCls || s[0] == ATcSqBrCls) k--;
                if (k < 0) break;
            }
            w->wpc[jj + 1] = s;  // IʒuL.
            if (t[j - 1] == ATcExpr && w->wpc[jj] == s) return 0; // 0͕sv.
            if (k > 0) return 0; // JbR̐[sv.
        } else if (t[j] != *s++)
            return 0; // svȂI.
    }
    w->wpc[1] = s; // ǂ܂œǂݐi߂.
    return 1; // t[Yׂ͂Ĉv.
}

AStatic AInt aIntLen(AInt *a)
{
	AInt l;
	for (l = 0; a[l] != 0; l++);
	return l;
}

AStatic char *AEasyC_delTkn(AEasyC_TknMan *tm, AInt *tkn, char **q, char *s1, AInt i)
{
	AInt l = tm->tLen[tkn[i]], j;
	memmove(q[i], q[i] + l, s1 + 1 - (q[i] + l));
	for (j = i; tkn[j] != 0; j++) {
		tkn[j] = tkn[j + 1];
		q[j] = q[j + 1] - l;
	}
	return s1 - l;
}

AStatic char *AEasyC_delTknStr(AEasyC_TknMan *tm, AInt *tkn, char **q, char *s1, AInt i, AInt n)
{
	AInt l = q[i + n - 1] + tm->tLen[tkn[i + n - 1]] - q[i], j;
	memmove(q[i], q[i] + l, s1 + 1 - (q[i] + l));
	for (j = i; tkn[j] != 0; j++) {
		tkn[j] = tkn[j + n];
		q[j] = q[j + n] - l;
	}
	return s1 - l;
}

AStatic char *AEasyC_insTkn(AEasyC_TknMan *tm, AInt *tkn, char **q, char *s1, AInt i, AInt tc)
{
	AInt l = tm->tLen[tc], j;
	memmove(q[i] + l + 1, q[i], s1 + 1 - q[i]);
	char *q0 = q[i];
	for (j = i; tkn[j] != 0; j++)
		q[j] += l + 1;
	for (; j >= i; j--) {
		tkn[j + 1] = tkn[j];
		q[j + 1] = q[j];
	}
	memcpy(q0, tm->tStr[tc], l);
	q0[l] = ' ';
	q[i] = q0;
	tkn[i] = tc;
	s1 += l + 1;
	if (q[i] > q[0] && q[i][-1] > ' ') {
		memmove(q[i] + 1, q[i], s1 + 1 - q[i]);
		for (j = i; tkn[j] != 0; j++)
			q[j]++;
		q[i][-1] = ' ';
		s1++;
	}
	return s1;
}

AStatic char *AEasyC_insTknStr(AEasyC_TknMan *tm, AInt *tkn, char **q, char *s1, AInt i, char *s)
// s̖̓Xy[XłƂ悢.
{
	AInt t[4096];
	char *p[4096];
	AEasyC_lexer(tm, s, t, (const char **) p);
	AInt n = aIntLen(t);
	AInt l = strlen(s), j;
	char *q0 = q[i];
	memmove(q0 + l, q0, s1 + 1 - q0);
	for (j = i; tkn[j] != 0; j++)
		q[j] += l;
	for (; j >= i; j--) {
		tkn[j + n] = tkn[j];
		q[j + n] = q[j];
	}
	memcpy(q0, s, l);
	for (j = 0; j < n; j++) {
		tkn[i + j] = t[j];
		q[i + j] = q0 + (p[j] - s);
	}
	s1 += l;
	if (q[i] > q[0] && q[i][-1] > ' ') {
		memmove(q[i] + 1, q[i], s1 + 1 - q[i]);
		for (j = i; tkn[j] != 0; j++)
			q[j]++;
		q[i][-1] = ' ';
		s1++;
	}
	return s1;
}

#if 0

AClass(AEasyC_TmpWrk) {
	void *p[8];
	int i[8];
};

AStatic int AEasyC_tkncmp(const char *s, int len, const char *t)
{
	int l = strlen(t);
	if (len == l && strncmp(s, t, len) == 0) return 1;
	return 0;
}

AStatic int AEasyC_tcmp(AEasyC_TmpWrk *tw, const char *t) { return AEasyC_tkncmp(tw->p[0], tw->i[0], t); }

#endif

AStatic char *ACA_EasyC_lv2(AComArg *aCA, const char *s0, AInt sz0, AInt *psz)
{
//	AEasyC_TmpWrk tw[1];
	AInt i, j, k, s0sz = strlen(s0);
//	char *s00 = AMem_malloc(aCA->mem, s0sz + 2), *s = s00;
	char *s = AMem_malloc(aCA->mem, sz0), *s1 = s + s0sz; memcpy(s, s0, s0sz + 1);
	AInt *tkn = AMem_malloc(aCA->mem, (s0sz + 4) * sizeof (AInt));
	char **q = AMem_malloc(aCA->mem, (s0sz + 4) * sizeof (char *));
	AEasyC_TknMan tm[1]; AEasyC_TknMan_initCa(aCA, tm, -1);
	AEasyC_PhrMan pm[1]; AEasyC_PhrMan_initCa(aCA, pm, 1000, tm);
	AInt *wpc[100]; pm->wpc = wpc;
	const char *r = AEasyC_lexer(tm, s, tkn, (const char **) q);
	if (*r != 0) {
		fprintf(stderr, "syntax error : %.10s (%02x:%02x:%02x:%02x)\n", r, r[0], r[1], r[2], r[3]);
		goto fin;
	}
	i = aIntLen(tkn);
 	s1 = AEasyC_insTkn(tm, tkn, q, s1, i, ATcSemi);
	for (i = 0; tkn[i] != 0; i++) {
		// 啶  .
		static char *tbl[] = { "PR", "GO", "IF", "PRS", "PRF", "INT", "FOR", "PRSP", "PRLF", "PRIS",
			"PLAY", "PLAY0", "PLAY1", "PLAY2", "PLAY3", "PLAY4", "PLAY5", "PRINTF",
			"I", "J", "K", "L", "M", "N", 0 };
		char **tStr = tm->tStr;
		AInt *tLen = tm->tLen;
		for (j = 0; tbl[j] != 0; j++) {
			if (strcmp(tStr[tkn[i]], tbl[j]) != 0) continue;
			for (j = 0; j < tLen[tkn[i]]; j++) {
				char c = q[i][j];
				if ('A' <= c && c <= 'Z')
					q[i][j] = c + ('a' - 'A');
			}
			tkn[i] = AEasyC_TknMan_tkn(tm, q[i], j);
			break;
		}
		// NHe[VC.
		if (q[i][0] == 0x22 || q[i][0] == 0x27) {
			j = tm->tLen[tkn[i]];
			if (j == 1 || q[i][j - 1] != q[i][0]) {
				memmove(&q[i][j + 1], &q[i][j], s1 + 1 - &q[i][j]);
				s1++;
				q[i][j] = q[i][0];
				tkn[i] = AEasyC_TknMan_tkn(tm, q[i], j + 1);
				for (j = i + 1; tkn[j] != 0; j++)
					q[j]++;
			}
		}
	}
	for (i = 0; tkn[i] != 0; ) {
		for (k = i; tkn[k] != 0 && tkn[k] != ATcSemi && tkn[k] != ATcCrBrOpn && tkn[k] != ATcCrBrCls; k++);
		char **tStr = tm->tStr;
		AInt kakko = 0, iskp = 1;
		if (strcmp(tStr[tkn[i]], "for") == 0 || strcmp(tStr[tkn[i]], "if") == 0 || strcmp(tStr[tkn[i]], "while") == 0) {
			for (k = i; tkn[k] != 0; k++) {
				if (tkn[k] == ATcBrOpn) kakko++;
				if (tkn[k] == ATcBrCls){
					kakko--;
					if (kakko == 0) {
						k++;
						iskp = 0;
						break;
					}
				}
			}
		}
		// 	JbR̎}.
		static char *tbl0[] = { "pr", "go", "prs", "prf", "pris", "prlf", "prsp", "play", "play0", "play1", "play2", "play3", "play4", "play5", 0 };
		for (j = 0; tbl0[j] != 0; j++) {
			if (strcmp(tStr[tkn[i]], tbl0[j]) != 0) continue;
			if (tkn[i + 1] == ATcBrOpn && tkn[k - 1] == ATcBrCls) break;
			s1 = AEasyC_insTkn(tm, tkn, q, s1, k, ATcBrCls);
			s1 = AEasyC_insTkn(tm, tkn, q, s1, i + 1, ATcBrOpn);
			k += 2;
			break;
		}
		// ȈՃ[vZq.
		wpc[0] = &tkn[i];
		char tmpStr[4096];
		tStr = tm->tStr;
		if (AEasyC_PhrMan_phr(pm, 0, "[!2] {")) {
			sprintf(tmpStr, "for (_tc0 = 0; _tc0 < %s; _tc0++) ", tStr[tkn[i + 1]]);
			s1 = AEasyC_delTknStr(tm, tkn, q, s1, i, 3);
			s1 = AEasyC_insTknStr(tm, tkn, q, s1, i, tmpStr);
			k = i + 13; iskp = 0;
		}
		if (AEasyC_PhrMan_phr(pm, 1, "[!2 = !3 :< !4] {")) {
			r = tStr[tkn[i + 1]];
			sprintf(tmpStr, "for (%s = %s; %s < %s; %s++) ", r, tStr[tkn[i + 3]], r, tStr[tkn[i + 5]], r);
			s1 = AEasyC_delTknStr(tm, tkn, q, s1, i, 7);
			s1 = AEasyC_insTknStr(tm, tkn, q, s1, i, tmpStr);
			k = i + 13; iskp = 0;
		}
		if (AEasyC_PhrMan_phr(pm, 2, "[!2 = !3 :<= !4] {")) {
			r = tStr[tkn[i + 1]];
			sprintf(tmpStr, "for (%s = %s; %s <= %s; %s++) ", r, tStr[tkn[i + 3]], r, tStr[tkn[i + 5]], r);
			s1 = AEasyC_delTknStr(tm, tkn, q, s1, i, 7);
			s1 = AEasyC_insTknStr(tm, tkn, q, s1, i, tmpStr);
			k = i + 13; iskp = 0;
		}
		for (j = i; j < k; j++) {
			if (tkn[j] == ATcOpLp2) {
				sprintf(tmpStr, "for (_tc0 = %s; _tc0 < %s; _tc0++) ", tStr[tkn[j - 1]], tStr[tkn[j + 1]]);
				s1 = AEasyC_delTknStr(tm, tkn, q, s1, j - 1, 3);
				s1 = AEasyC_insTknStr(tm, tkn, q, s1, j - 1, "_tc0 ");
				s1 = AEasyC_insTknStr(tm, tkn, q, s1, i, tmpStr);
				k = i + 13; iskp = 0;
				break;
			}
			if (tkn[j] == ATcOpLp4) {
				sprintf(tmpStr, "for (_tc0 = %s; _tc0 <= %s; _tc0++) ", tStr[tkn[j - 1]], tStr[tkn[j + 1]]);
				s1 = AEasyC_delTknStr(tm, tkn, q, s1, j - 1, 3);
				s1 = AEasyC_insTknStr(tm, tkn, q, s1, j - 1, "_tc0 ");
				s1 = AEasyC_insTknStr(tm, tkn, q, s1, i, tmpStr);
				k = i + 13; iskp = 0;
				break;
			}
		}
		i = k; if (tkn[k] != 0) i += iskp;
	}
fin:
	AMem_free(aCA->mem, (s0sz + 4) * sizeof (AInt), tkn);
	AMem_free(aCA->mem, (s0sz + 4) * sizeof (char *), q);
	AEasyC_PhrMan_dein(pm);
	AEasyC_TknMan_dein(tm);
	*psz = s1 - s;
	return s;


#if 0

	char *lb = AMem_malloc(aCA->mem, 64 * 1024);
	sprintf(s, "%s;", s0);
	int kakko = 0;
	while (*s != 0) {
		int l = AEasyC_strlenLf1(s);
		if (l == 0) break;
		memcpy(lb, s, l);
		s += l;
		while (l > 0 && (lb[l - 1] == ' ' || lb[l - 1] == '\n' || lb[l - 1] == '\t' || lb[l - 1] == '\r')) l--;
		lb[l] = 0;
		int i = 0;
		char flg = 0, flg2 = 0;
		while (lb[i] == ' ' || lb[i] == '\n' || lb[i] == '\t' || lb[i] == '\r') { i++; }
		if (lb[i] == '#') goto skip;
		const char *r = AEasyC_lexer(tm, &lb[i], tkn, q);
		if (*r != 0) {
			fprintf(stderr, "syntax error : %.10s (%02x:%02x:%02x:%02x)\n", r, r[0], r[1], r[2], r[3]);
			goto fin;
		}
		int ii, jj;
		for (ii = 0; tkn[ii] != 0; ii++) {
			static char *tbl[] = { "PR", "GO", "IF", "PRS", "PRF", "INT", "FOR", "PRSP", "PRLF", "PRIS",
				"PLAY", "PLAY0", "PLAY1", "PLAY2", "PLAY3", "PLAY4", "PLAY5", "PRINTF", 0 };
			for (jj = 0; tbl[jj] != 0; jj++) {
				if (strcmp(tm->tStr[tkn[ii]], tbl[jj]) != 0) continue;
				for (jj = 0; jj < tm->tLen[tkn[ii]]; jj++) {
					char c = q[ii][jj];
					if ('A' <= c && c <= 'Z')
						((char **) q)[ii][jj] = c + ('a' - 'A');
				}
				tkn[ii] = AEasyC_TknMan_tkn(tm, q[ii], jj);
				break;
			}
		}

		for (ii = 0; tkn[ii] != 0; ) {
			wpc[0] = &tkn[ii];

//		while (tkn[ii] != 0) {
//JbRĂȂƂ




		while (lb[i] != 0) {
			if (lb[i] == ' ' || lb[i] == '\n' || lb[i] == '\t' || lb[i] == '\r') { i++; continue; }
			int len = 0;
			if (strchr("(){}[];,", lb[i]) != 0)
				len = 1;
			else if (AEasyC_isAlphabetOrNumber(lb[i]) != 0) {  // 1ڂp.
				while (AEasyC_isAlphabetOrNumber(lb[i + len]) != 0)
					len++;
			} else if (strchr("=+-*/!%&^~|<>?:.#", lb[i]) != 0) {  // 1ڂʂ̋L.
            	while (lb[i + len] != 0 && strchr("=+-*/!%&^~|<>?:.#", lb[i + len]) != 0)
                	len++;
			} else if (lb[i] == 0x22 || lb[i] == 0x27) {
				len = 1;
				while (lb[i + len] != lb[i] && lb[i + len] != 0) len++;
				if (lb[i + len] == lb[i]) len++;
			} else {
	            fprintf(stderr, "syntax error : %.10s (%02x:%02x:%02x:%02x)\n", &lb[i], lb[i], lb[i + 1], lb[i + 2], lb[i + 3]);
				goto fin;
			}
			if (len >= 2 && lb[i] == '/' && lb[i + 1] == '/') break;
			if (len == 1 && 'I' <= lb[i] && lb[i] <= 'N') lb[i] += 'a' - 'A';
			tw->p[0] = &lb[i];
			tw->i[0] = len;
#if 0
			if (AEasyC_tcmp(tw, "PR")) memcpy(&lb[i], "pr", 2);
			if (AEasyC_tcmp(tw, "GO")) memcpy(&lb[i], "go", 2);
			if (AEasyC_tcmp(tw, "IF")) memcpy(&lb[i], "if", 2);
			if (AEasyC_tcmp(tw, "PRS")) memcpy(&lb[i], "prs", 3);
			if (AEasyC_tcmp(tw, "PRF")) memcpy(&lb[i], "prf", 3);
			if (AEasyC_tcmp(tw, "INT")) memcpy(&lb[i], "int", 3);
			if (AEasyC_tcmp(tw, "FOR")) memcpy(&lb[i], "for", 3);
			if (AEasyC_tcmp(tw, "PRSP")) memcpy(&lb[i], "prsp", 4);
			if (AEasyC_tcmp(tw, "PRLF")) memcpy(&lb[i], "prlf", 4);
			if (AEasyC_tcmp(tw, "PLAY")) memcpy(&lb[i], "play", 4);
			if (AEasyC_tcmp(tw, "PLAY0")) memcpy(&lb[i], "play0", 5);
			if (AEasyC_tcmp(tw, "PLAY1")) memcpy(&lb[i], "play1", 5);
			if (AEasyC_tcmp(tw, "PLAY2")) memcpy(&lb[i], "play2", 5);
			if (AEasyC_tcmp(tw, "PLAY3")) memcpy(&lb[i], "play3", 5);
			if (AEasyC_tcmp(tw, "PLAY4")) memcpy(&lb[i], "play4", 5);
			if (AEasyC_tcmp(tw, "PLAY5")) memcpy(&lb[i], "play5", 5);
			if (AEasyC_tcmp(tw, "PRINTF")) memcpy(&lb[i], "printf", 6);
#endif
			if (len == 1 && lb[i] == ';' && kakko == 0) {
				if (flg != 0) {
					memmove(&lb[i + 1], &lb[i], l - i + 1);
					lb[i++] = ')';
					l++;
				}
				flg = 0;
				flg2 = 0;
			}
			if (len == 1 && lb[i] == '(') kakko++;
			if (len == 1 && lb[i] == ')') {
				kakko--;
				if (kakko == 0 && flg2 == 1) flg2 = 2;
				i++;
				continue;
			}
			if (AEasyC_tcmp(tw, "}")) {
				flg2 = 0;
			}
			if (AEasyC_tcmp(tw, "if")) flg2 = 1;
			else if (AEasyC_tcmp(tw, "for")) flg2 = 1;
			else if (AEasyC_tcmp(tw, "else")) flg2 = 2;
			else if (AEasyC_tcmp(tw, "do")) flg2 = 2;
			else if (AEasyC_tcmp(tw, "while")) flg2 = 1;
			else if (flg2 == 2) flg2 = 0;
			char flg1 = 0;
			if (AEasyC_tcmp(tw, "pr")) flg1 = 1;
			if (AEasyC_tcmp(tw, "go")) flg1 = 1;
			if (AEasyC_tcmp(tw, "prs")) flg1 = 1;
			if (AEasyC_tcmp(tw, "prf")) flg1 = 1;
			if (AEasyC_tcmp(tw, "prsp")) flg1 = 1;
			if (AEasyC_tcmp(tw, "prlf")) flg1 = 1;
			if (AEasyC_tcmp(tw, "play")) flg1 = 1;
			if (AEasyC_tcmp(tw, "play0")) flg1 = 1;
			if (AEasyC_tcmp(tw, "play1")) flg1 = 1;
			if (AEasyC_tcmp(tw, "play2")) flg1 = 1;
			if (AEasyC_tcmp(tw, "play3")) flg1 = 1;
			if (AEasyC_tcmp(tw, "play4")) flg1 = 1;
			if (AEasyC_tcmp(tw, "play5")) flg1 = 1;
			i += len;
			if (flg1 != 0) {
				while (lb[i] == ' ' || lb[i] == '\n' || lb[i] == '\t') i++;
				if (lb[i] != '(') {
					flg = 1;
					memmove(&lb[i + 1], &lb[i], l - i + 1);
					lb[i++] = '(';
					l++;
				}
			}
		}
		if (lb[i] == 0 && flg2 == 0 && kakko == 0) {
			if (flg != 0) {
				lb[i++] = ')';
				l++;
			}
		}
skip:
		memcpy(&b[j], lb, l);
		j += l;
		b[j++] = '\n';
	}
fin:
	b[j] = 0;
	AMem_free(aCA->mem, 64 * 1024, lb);
	AMem_free(aCA->mem, s0sz + 2, s00);
	AMem_free(aCA->mem, 64 * 1024 * sizeof (AInt), tkn);
	AMem_free(aCA->mem, 64 * 1024 * sizeof (char *), q);
	AEasyC_TknMan_dein(tm);
	*psz = j;
	return b;
#endif
}

AStatic int ACA_EasyC_exec(AComArg *aCA, const char *s, const char *fnam)
{
	char fileC[4096], fileX[4096];
	AInt i;
	sprintf(fileC, "%s.c",   fnam);
	sprintf(fileX, "%s.exe", fnam);
	FILE *fp = fopen(fileC, "wb");
	char *p = ACA_EasyC_lv2(aCA, s, 1024 * 1024, &i);
	fprintf(fp, "#include \"ec_inc0.c\"\n#line 1 \"cmdline\"\n%s\n#include \"ec_inc1.c\"\n", p);
	fclose(fp);
	sprintf(fileC, "gcc -m32 -Wall -Wextra -Wl,-s,-Map,%s_map.txt -Wno-unused-function -Wno-unused-but-set-variable -Wno-unused-label -O0 -DAArch_X86 -DAGraph_Win -DADbgLv=1 -DAStatic= -I./acl1 -o %s.exe %s.c -lgdi32 -lwinmm", fnam, fnam, fnam);
	i = system(fileC);
	if (i == 0)
		i = system(fileX);
	AMem_free(aCA->mem, 1024 * 1024, p);
	return i;
}

AStatic int ACA_EasyC_run(AComArg *aCA, const char *path, const char *fnam)
{
	char cachePath[4096], cacheExe[4096+4], s[4096*3], fileC[4096];
	sprintf(cachePath, "cache\\%s", path);
	sprintf(fileC, "%s.c", fnam);
	AInt i, sz0, sz1, retVal = 1;
	FILE *fp;
	for (i = 6; cachePath[i] != 0; i++) {
		if (cachePath[i] == '/' || cachePath[i] == ':' || cachePath[i] == '\\')
			cachePath[i] = '_';
	}
	sprintf(cacheExe, "%s.exe", cachePath);
	char *b0 = aLoadFile(path,      16 * 1024 * 1024, 1, &sz0, 1+4+16);
	char *b1 = aLoadFile(cachePath, 16 * 1024 * 1024, 0, &sz1, 4+16);
	if (sz0 < 0 || sz0 >= 16 * 1024 * 1024) goto fin;
	if (sz0 == sz1 && memcmp(b0, b1, sz0) == 0) {
		fp = fopen(cacheExe, "rb");
		fclose(fp);
		if (fp != 0) goto skip;
	}
	fp = fopen(fileC, "wb");
	if (strstr(b0, "#include <acl1.c>") == 0) {
		char *p = ACA_EasyC_lv2(aCA, b0, 16 * 1024 * 1024, &i);
		fprintf(fp, "#include \"ec_inc0.c\"\n#line 1 \"%s\"\n%s\n#include \"ec_inc1.c\"\n", path, p);
		AMem_free(aCA->mem, 16 * 1024 * 1024, p);
	} else
		fprintf(fp, "%s", b0);
	fclose(fp);
	sprintf(s, "gcc -m32 -Wall -Wextra -Wl,-s,-Map,%s_map.txt -Wno-unused-function -Wno-unused-but-set-variable -Wno-unused-label -Os -DAArch_X86 -DAGraph_Win -DADbgLv=1 -DAStatic= -I./acl1 -o %s %s -lgdi32 -lwinmm", fnam, cacheExe, fileC);
	if (system(s) != 0) return 1;
	fp = fopen(cachePath, "wb");
	fwrite(b0, 1, sz0, fp);
	fclose(fp);
skip:
	retVal = system(cacheExe);
fin:
	if (sz0 > 0)
		AMem_free(aCA->mem, 16 * 1024 * 1024 + 1, b0);
	if (sz1 > 0)
		AMem_free(aCA->mem, 16 * 1024 * 1024, b1);
	return retVal;
}

AClass(APcg) {
	AInt32 xsz, ysz, col[128], bc, xsc, ysc;
	AInt32 *pcg;
	AInt pos1, pos2c, pos2y, pos3x, pos3y;
	void *mem;
	AWin *win;
};

AStatic void APcg_initCa(AComArg *aCA, APcg *w)
{
	AInt i;
	w->xsz = w->ysz = 16;
	w->xsc = w->ysc = 1;
	w->pcg = 0;
	w->mem = aCA->mem;
	w->pos1 = 'A';
	w->pos2y = w->pos3x = w->pos3y = 0;
	w->pos2c = 'A';
	w->pos2y = 0;
	for (i = 0; i < 8; i++)
		w->col[i + '0'] = AWin_colTbl16[i];
}

AStatic void APcg_dein(APcg *w)
{
	if (w->pcg != 0) {
		AMem_free(w->mem, w->xsz * w->ysz * 128 * sizeof (AInt32), w->pcg);
//		w->pcg = 0;
	}
}

AStatic void APcg_set0(APcg *w, AInt opt, AInt p0, AInt p1)
{
	if (opt == 0) {
		w->win = (AWin *) p0;
		w->bc = p1;
	}
	if (opt == 1) {
		w->pos1 = p0;
	}
	if (opt == 2) {
		w->pos2c = p0;
		w->pos2y = p1;
	}
	if (opt == 3) {
		w->pos3x = p0;
		w->pos3y = p1;
	}
	if (opt == 4) {
		w->xsz = p0;
		w->ysz = p1;
	}
	if (opt == 5) {
		w->xsc = p0;
		w->ysc = p1;
	}
}

AStatic void APcg_set0pi(APcg *w, AInt opt, void *p0, AInt p1) { APcg_set0(w, opt, (AInt) p0, p1); }

AStatic void APcg_set1(APcg *w, const char *s)
{
	char *t;
	for (;;) {
		while (0 < *s && *s <= ' ') s++;
		AInt i = strtol(s, &t, 16);
		if (s == t) break;
		w->col[w->pos1++] = i;
		s = t;
	}
}

AStatic void APcg_set2(APcg *w, const char *s)
{
	if (w->pcg == 0) {
		AInt i, i1 = w->xsz * w->ysz * 128;
		w->pcg = AMem_malloc(w->mem, i1 * sizeof (AInt32));
		for (i = 0; i < i1; i++)
			w->pcg[i] = w->bc;
	}
	AInt cy = w->pos2c * w->xsz * w->ysz + w->pos2y * w->xsz, x = 0;
	while (*s != 0) {
		w->pcg[cy + x] = w->col[(unsigned char) *s++];
		x++;
		if (x == w->xsz) {
			x = 0;
			cy += w->xsz * w->ysz;
		}
	}
	w->pos2y++;
	if (w->pos2y == w->ysz) {
		w->pos2c = cy / (w->xsz * w->ysz);
		w->pos2y = 0;
	}
}

AStatic void APcg_set3(APcg *w, const char *s)
{
	AWin *win = w->win;
	AInt32 *q = &win->buf[w->pos3y * win->xsiz + w->pos3x];
	if (w->xsc == 1 && w->ysc == 1) {
		while (*s != 0) {
			AInt c = *s++, x, y;
			AInt32 *p = &w->pcg[c * w->xsz * w->ysz];
			for (y = 0; y < w->ysz; y++) {
				for (x = 0; x < w->xsz; x++)
					q[x] = p[x];
				p += x;
				q += win->xsiz;
			}
			q -= win->xsiz * w->ysz - w->xsz;
		}
	} else {
		while (*s != 0) {
			AInt c = *s++, x, y, u, v;
			AInt32 *p = &w->pcg[c * w->xsz * w->ysz];
			for (y = 0; y < w->ysz; y++) {
				for (x = 0; x < w->xsz; x++) {
					for (v = 0; v < w->ysc; v++) {
						for (u = 0; u < w->xsc; u++)
							*q++ = p[x];
						q += win->xsiz - w->xsc;
					}
					q -= win->xsiz * w->ysc - w->xsc;
				}
				p += x;
				q += win->xsiz * w->ysc - w->xsz * w->xsc;
			}
			q -= win->xsiz * w->ysz * w->ysc - w->xsz * w->xsc;
		}
	}
	w->pos3y += w->ysz * w->ysc;
}

APcg *AAutoPcg_p = 0;

#if 0
AWin *AAutoWin_p = 0;
AStatic void AAutoWin(AComArg *aCA, AInt x, AInt y)
{
	if (AAutoPcg_p != 0) {
		APcg_dein(AAutoPcg_p);
		AMem_free(aCA->mem, sizeof (APcg), AAutoPcg_p);
		AAutoPcg_p = 0;
	}
	if (AAutoWin_p != 0) {
		AWin_dein(AAutoWin_p);
		aWait(500);
	}
	AAutoWin_p = aOpenWin(x, y, "graphics");
	aWait(500);
}
#endif

AStatic void AAutoPcg0(AComArg *aCA, AInt opt, AInt p0, AInt p1)
{
	if (AAutoPcg_p == 0) {
		AAutoPcg_p = AMem_malloc(aCA->mem, sizeof (APcg));
		APcg_initCa(aCA, AAutoPcg_p);
//		APcg_set0(AAutoPcg_p, 0, (AInt) AAutoWin_p, 0);
	}
//	if (opt == 0) p0 = (AInt) AAutoWin_p;
	APcg_set0(AAutoPcg_p, opt, p0, p1);
}

AStatic void AAutoPcg1(AComArg *aCA, const char *s)
{
	if (AAutoPcg_p == 0) {
		AAutoPcg_p = AMem_malloc(aCA->mem, sizeof (APcg));
		APcg_initCa(aCA, AAutoPcg_p);
//		APcg_set0(AAutoPcg_p, 0, (AInt) AAutoWin_p, 0);
	}
	APcg_set1(AAutoPcg_p, s);
}

AStatic void AAutoPcg2(AComArg *aCA, const char *s)
{
	if (AAutoPcg_p == 0) {
		AAutoPcg_p = AMem_malloc(aCA->mem, sizeof (APcg));
		APcg_initCa(aCA, AAutoPcg_p);
//		APcg_set0(AAutoPcg_p, 0, (AInt) AAutoWin_p, 0);
	}
	APcg_set2(AAutoPcg_p, s);
}

AStatic void AAutoPcg3(AComArg *aCA, const char *s)
{
	if (AAutoPcg_p == 0) {
		AAutoPcg_p = AMem_malloc(aCA->mem, sizeof (APcg));
		APcg_initCa(aCA, AAutoPcg_p);
//		APcg_set0(AAutoPcg_p, 0, (AInt) AAutoWin_p, 0);
	}
	APcg_set3(AAutoPcg_p, s);
}

AStatic AInt aMaxInt(AInt i0, AInt i1)
{
	if (i0 <= i1) return i1;
	return i0;
}

AStatic AInt aMinInt(AInt i0, AInt i1)
{
	if (i0 >= i1) return i1;
	return i0;
}

#define AXFnc_i2(i, j, dmy, f)			(f, i = aCA->com->retValInt[0], j = aCA->com->retValInt[1])
#define AXFnc_i3(i, j, k, dmy, f)		(f, i = aCA->com->retValInt[0], j = aCA->com->retValInt[1], k = aCA->com->retValInt[2])

