#define a_Version 1
#include <acl4.c>

class_(Var) { SetElm elm[1]; double d; };
Set0 setVar[1];

double *getVarPtr(const char *s, intptr_t n)
{
    Var *v = Set0_findKn(setVar, s, n);
    if (v == NULL) {
        v = malloc_(_arg_  sizeof (Var));
        v->elm->k = s;
        v->elm->n = n;
        v->d = 0.0;
        Set0_add(setVar, v->elm);
    }
    return &(v->d);
}

int np = 0;

double eval(Token0 *t0, int pri)
{
    const char *t = Token1_get(t0); double d = 0.0, *pd = NULL; intptr_t n = t0->len; uint32_t c = t0->c;
    if (n == 0) return d;
    if (c == '(') { d = eval(t0, 99); Token1_get(t0); goto op2; }
    if (c == '+' && pri >= 2) { d = +       eval(t0, 2); goto op2; }
    if (c == '-' && pri >= 2) { d = -       eval(t0, 2); goto op2; }
    if (c == '!' && pri >= 2) { d = ! (int) eval(t0, 2); goto op2; }
    if (c == '~' && pri >= 2) { d = ~ (int) eval(t0, 2); goto op2; }
    if (pri >= 2 && n == 3 && memcmp(t, "sin",   3) == 0) { d = sin( eval(t0, 2)); goto op2; }
    if (pri >= 2 && n == 3 && memcmp(t, "cos",   3) == 0) { d = cos( eval(t0, 2)); goto op2; }
    if (pri >= 2 && n == 3 && memcmp(t, "tan",   3) == 0) { d = tan( eval(t0, 2)); goto op2; }
    if (pri >= 2 && n == 3 && memcmp(t, "exp",   3) == 0) { d = exp( eval(t0, 2)); goto op2; }
    if (pri >= 2 && n == 3 && memcmp(t, "log",   3) == 0) { d = log( eval(t0, 2)); goto op2; }
    if (pri >= 2 && n == 4 && memcmp(t, "sqrt",  4) == 0) { d = sqrt(eval(t0, 2)); goto op2; }
    if (pri >= 2 && n == 5 && memcmp(t, "print", 5) == 0) { d = eval(t0, 97); printf("%f\n", d); np++; goto op2; }
    if ('0' <= *t && *t <= '9')
        d = strtod(t, NULL);
    else {
        pd = getVarPtr(t, n);
        d = *pd;
    }
op2:
    t = Token1_get(t0); c = t0->c; n = t0->len;
    if (n == 0) return d;
    if (c ==  '*'             && pri >=  4) { d =       d *        eval(t0,  3); goto op2; }
    if (c ==  '/'             && pri >=  4) { d =       d /        eval(t0,  3); goto op2; }
    if (c ==  '%'             && pri >=  4) { d = (int) d % (int)  eval(t0,  3); goto op2; }
    if (c ==  '+'             && pri >=  5) { d =       d +        eval(t0,  4); goto op2; }
    if (c ==  '-'             && pri >=  5) { d =       d -        eval(t0,  4); goto op2; }
    if (c == ('<' | '<' << 8) && pri >=  6) { d = (int) d << (int) eval(t0,  5); goto op2; }
    if (c == ('>' | '>' << 8) && pri >=  6) { d = (int) d >> (int) eval(t0,  5); goto op2; }
    if (c == ('<' | '=' << 8) && pri >=  7) { d =       d <=       eval(t0,  6); goto op2; }
    if (c ==  '<'             && pri >=  7) { d =       d <        eval(t0,  6); goto op2; }
    if (c == ('>' | '=' << 8) && pri >=  7) { d =       d >=       eval(t0,  6); goto op2; }
    if (c ==  '>'             && pri >=  7) { d =       d >        eval(t0,  6); goto op2; }
    if (c == ('=' | '=' << 8) && pri >=  8) { d =       d ==       eval(t0,  7); goto op2; }
    if (c == ('!' | '=' << 8) && pri >=  8) { d =       d !=       eval(t0,  7); goto op2; }
    if (c ==  '&'             && pri >=  9) { d = (int) d &  (int) eval(t0,  8); goto op2; }
    if (c ==  '^'             && pri >= 10) { d = (int) d ^  (int) eval(t0,  9); goto op2; }
    if (c ==  '|'             && pri >= 11) { d = (int) d |  (int) eval(t0, 10); goto op2; }
    if (c == ('&' | '&' << 8) && pri >= 12) { d = (int) d && (int) eval(t0, 11); goto op2; }
    if (c == ('|' | '|' << 8) && pri >= 13) { d = (int) d || (int) eval(t0, 12); goto op2; }
    if (c == '='              && pri >= 15) { d = eval(t0, 15); if (pd != NULL) { *pd = d; } goto op2; }
    if (c ==  ';'             && pri >= 98) { d =                  eval(t0, 97); goto op2; }
    t0->s = t; return d; // 一度読み込んだ未解釈の演算子をt0に押し戻してからreturn.
}

void myPut(Preprocessor_Put0 *w, VecChr *lin)
{
    // エラーが起きて未処理扱いになったプリプロセッサ制御行があれば、それはエラー出力して変換結果に含めない.
    if (Preprocessor_isDirective(lin->p, lin->p + lin->n) != 0)
        fprintf(stderr, "[err] %.*s", (int) lin->n, lin->p);
    else
        VecChr_puts(w->dst, lin->p, lin->p + lin->n);
}

int main(int argc, const char **argv)
{
    if (argc < 2) return 1;
    Preprocessor pp[1]; Preprocessor_ini(pp);                            // プリプロセッサの初期化.
    pp->put = (void *) myPut;                                            // 出力関数の変更.
    Preprocessor_SourceFiles_addFile(pp->sfs, argv[1], strlen(argv[1])); // 入力ファイルを指定.
    VecChr vc[1]; VecChr_ini(vc); pp->put0->dst = vc;                    // 出力先のオブジェクトを指定.
    Preprocessor_main(pp); Preprocessor_din(pp);                         // プリプロセッサ処理. およびメモリ開放.

    Token0 t0[1]; Token0_ini1(t0); // ここから下は p0002b.c の main にあったものをそのまま使用.
    Set0_ini(setVar);
    t0->s = vc->p; t0->s1 = vc->p + vc->n;
    double d = eval(t0, 99);
    if (np == 0)
         printf("%f\n", d);
    VecChr_din(vc);
    intptr_t i, n = setVar->tbl->n / sizeof (Var *);
    for (i = 0; i < n; i++)
        free_(_arg_  ((Var **) setVar->tbl->p)[i], sizeof (Var));
    Set0_din(setVar);
    a_malloc_debugList(_arg);
    return 0;
}
