#if (a_Version >= 1)
    #define Token0_ini1     a_Token0_ini1
    #define VecChr_convEsc  a_VecChr_convEsc
    #define VecChr_iniArg   a_VecChr_iniArg
#endif

a_static void a_Token0_ini1(a_Token0 *w)
{
    static a_Token0Table t0t[1];
    a_Token0Table_ini(t0t);
    w->tbl = t0t;
}

a_static void a_VecChr_convEsc(a_VecChr *w)
{
    a_VecChr_reserveDiff(w, 4);
    memset(w->p + w->n, 0, 4);
    char *p, *q, *p1;
    p = q = w->p;
    p1 = p + w->n;
    while (p < p1) {
        if (*p == '\\') {
        if (p[1] == 'a') { *q++ = '\a'; p += 2; continue; }
        if (p[1] == 'b') { *q++ = '\b'; p += 2; continue; }
        if (p[1] == 'f') { *q++ = '\f'; p += 2; continue; }
        if (p[1] == 'n') { *q++ = '\n'; p += 2; continue; }
        if (p[1] == 'r') { *q++ = '\r'; p += 2; continue; }
        if (p[1] == 't') { *q++ = '\t'; p += 2; continue; }
        if (p[1] == 'v') { *q++ = '\v'; p += 2; continue; }
        if (p[1] == 'x') {
            *q++ = (char) strtol(p + 1, &p, 16);
            if (strchr(",.;:", *p) != NULL) p++;
            continue;
        }
        if ('0' <= p[1] && p[1] <= '7') {
            *q++ = (char) strtol(p + 1, &p, 8);
            if (strchr(",.;:", *p) != NULL) p++;
            continue;
        }
        p++;
        *q++ = *p++;
    } else
        *q++ = *p++;
    }
    w->n -= p1 - q;
    a_VecChr_reserve0(w);
}

a_static void a_VecChr_iniArg(a_VecChr *w, int argc, const char **argv, int i, int flg)
// flg=1:デフォルトをinlineモードに変更.
//     2:ファイルから読んだ場合にeraseCrする.
//     4:inlineの場合でも、convEscしない.
//     8:fileの場合に、convEscする.
//    16:最初にiniしない.
// 典型値: flg=0(file-bin), flg=2(file-txt)
//         flg=1(inline-bin), flg=3(inline-txt)
// file:かinline:か。明示しなければデフォルト値が使われる.
{
    if ((flg & 16) == 0)
        a_VecChr_ini(w);
    if (argc <= i)
        a_errExit("VecChr_iniArg: missing args. (i=%d, argc=%d)", i, argc);
    w->n = 0;
    a_VecChr_puts(w, argv[i], argv[i] + strlen(argv[i]));
    if (w->p[0] == 0x22) {
        a_VecChr_replace(w, 0, 1, NULL, 0);
        if (w->n > 0 && w->p[w->n - 1] == 0x22)
            w->n--;
    }
    if (w->n >= 5 && memcmp(w->p, "file:", 5) == 0) {
        a_VecChr_replace(w, 0, 5, NULL, 0);
        flg &= ~1;
    }
    if (w->n >= 7 && memcmp(w->p, "inline:", 7) == 0) {
        a_VecChr_replace(w, 0, 7, NULL, 0);
        flg |= 1;
    }
    if ((flg & 1) == 0) {
        a_VecChr_reserve0(w);
        w->n = 0;
        a_VecChr_readFileAll_errChk(w, w->p);
        if ((flg & 2) != 0)
            a_VecChr_eraseCr(w);
        if ((flg & 8) != 0)
            flg |= 256;
    } else {
        if ((flg & 4) == 0)
            flg |= 256;
    }
    if ((flg & 256) != 0)
        a_VecChr_convEsc(w);
}
