#if (a_Version >= 1)
    #define VecChr_replace      a_VecChr_replace
    #define VecChr_gets         a_VecChr_gets
    #define VecChr_puts         a_VecChr_puts
    #define VecChr_hexDump      a_VecChr_hexDump
    #define Set0_findKn         a_Set0_findKn
    #define parseArgs           a_parseArgs
#endif

a_static void a_VecChr_replace(a_VecChr *w, intptr_t pos0, intptr_t n0, const void *p1, intptr_t n1)
{
    intptr_t diff = n1 - n0, pos1 = pos0 + n0, n2 = w->n - pos1;
    a_VecChr_resizeDiff(_arg_  w, diff);
    if (diff != 0 && n2 > 0) memmove(w->p + pos1 + diff, w->p + pos1, n2);
    if (n1 > 0) memcpy(w->p + pos0, p1, n1);
}

a_static char *a_VecChr_gets(a_VecChr *v, const char *s, const char *s1)
{
    const char *t = memchr(s, '\n', s1 - s);
    if (t == NULL) t = s1 - 1;
    t++;
    a_VecChr_reserve(v, t - s + 1);
    if (s < t) memcpy(v->p, s, t - s);
    v->n = t - s;
    v->p[t - s] = '\0';
    return (char *) t;
}

a_static void a_VecChr_puts(a_VecChr *v, const char *s, const char *s1)
{
    a_VecChr_reserveDiff(v, s1 - s + 1);
    if (s < s1) memcpy(v->p + v->n, s, s1 - s);
    v->n += s1 - s;
    v->p[v->n] = '\0';
}

a_static void a_VecChr_hexDump(a_VecChr *w, FILE *fp)
{
    intptr_t i;
    fprintf(fp, "[");
    for (i = 0; i < w->n; i++)
        fprintf(fp, "%02X ", ((unsigned char *) w->p)[i]);
    fprintf(fp, "]\n");
}

a_static void *a_Set0_findKn(a_Set0 *w, const void *k, intptr_t n)
{
    a_SetElm elm[1];
    elm->k = k;
    elm->n = n;
    return a_Set0_find(w, elm);
}

a_static char *a_parseArgs(a_Token0 *t0, a_VecChr *v)
{
    intptr_t nest = 0, len;
    char flg = 0;
    v->n = 0;
    const char *s = NULL, *t, **p;
    for (;;) {
        len = t0->len; t = s;
        s = a_Token1_get(t0);
        if (t0->len == 0) {
            if (flg != 0) {
                p = a_VecChr_stkAdd(v, sizeof (char *));
                *p = s;
            }
            break;
        }
        if (*s == ',') {
            if (nest == 0 && flg != 0) {
                p = a_VecChr_stkAdd(v, sizeof (char *));
                *p = t + len; flg = 0;
            }
            continue;
        }
        if (*s == ')' || *s == '}' || *s == ']') nest--;
        if (nest < 0) {
            if (flg != 0) {
                p = a_VecChr_stkAdd(v, sizeof (char *));
                *p = t + len;
            }
            break;
        }
        if (flg == 0 && nest == 0) {
            p = a_VecChr_stkAdd(v, sizeof (char *));
            *p = s; flg = 1;
        }
        if (*s == '(' || *s == '{' || *s == '[') nest++;
    }
    return (char *) s;
}
