#if (a_Version >= 1)
    #define VecChr_vprintf              a_VecChr_vprintf
    #define VecChr_printf               a_VecChr_printf
    #define VecChr_putc                 a_VecChr_putc
    #define VecChr_readFileAll          a_VecChr_readFileAll
    #define VecChr_readFileAll_errChk   a_VecChr_readFileAll_errChk
    #define VecChr_eraseCr              a_VecChr_eraseCr
    #define VecChr_writeFileAll         a_VecChr_writeFileAll
    #define VecChr_writeFileAll_errChk  a_VecChr_writeFileAll_errChk
    #define VecChr_stkAdd               a_VecChr_stkAdd
    #define VecChr_stkRmv               a_VecChr_stkRmv
#endif

a_static intptr_t a_VecChr_vprintf(a_VecChr *w, const char *f, va_list a)
{
    intptr_t d = w->n1 - w->n;
    intptr_t i = vsnprintf(w->p + w->n, d, f, a);
    if (i <= 0) goto fin;
    if (i + 1 > d) {
        a_VecChr_reserveDiff(w, i + 1);
        d = w->n1 - w->n;
        i = vsnprintf(w->p + w->n, d, f, a);
        if (i <= 0) goto fin;
    }
    w->n += i;
fin:
    return i;
}

a_static intptr_t a_VecChr_printf(a_VecChr *w, const char *f, ...)
{
    va_list ap;
    va_start(ap, f);
    intptr_t i = a_VecChr_vprintf(w, f, ap);
    va_end(ap);
    return i;
}

a_static int a_VecChr_putc(a_VecChr *w, int c)
{
    a_VecChr_reserveDiff(w, 2);
    w->p[w->n++] = c;
    w->p[w->n] = '\0';
    return c;
}

a_static intptr_t a_VecChr_readFileAll(a_VecChr *w, const char *path)
{
    FILE *fp = fopen(path, "rb");
    if (fp == NULL) return -1;
    intptr_t bufSz = 1024 * 1024, n0 = w->n;
    for (;;) {
        a_VecChr_reserveDiff(w, bufSz);
        intptr_t i = (intptr_t) fread(w->p + w->n, 1, bufSz, fp);
        if (i <= 0) break;
        w->n += i;
    }
    fclose(fp);
    a_VecChr_reserve0(w);
    a_VecChr_shrink(_arg_  w, 1);
    return w->n - n0;
}

a_static intptr_t a_VecChr_readFileAll_errChk(a_VecChr *w, const char *path)
{
    if (path == NULL) a_errExit("fopen error: path=NULL");
    intptr_t i = a_VecChr_readFileAll(w, path);
    if (i < 0) a_errExit("fopen error: %s", path);
    return i;
}

a_static intptr_t a_VecChr_eraseCr(a_VecChr *w)
{
    char *p, *q, *p1;
    p = q = w->p;
    p1 = p + w->n;
    while (p < p1) {
        if (*p++ != '\r')
            *q++ = p[-1];
    }
    w->n -= p1 - q;
    a_VecChr_reserve0(w);
    return p1 - q;
}

a_static intptr_t a_VecChr_writeFileAll(a_VecChr *w, const char *path, const char *mod)
{
    FILE *fp = fopen(path, mod);
    if (fp == NULL) return -1;
    intptr_t i = 0, j;
    for (;;) {
        j = fwrite(w->p + i, 1, w->n - i, fp);
        if (j <= 0) break;
        i += j;
    }
    fclose(fp);
    return i;
}

a_static intptr_t a_VecChr_writeFileAll_errChk(a_VecChr *w, const char *path, const char *mod)
{
    if (path == NULL) a_errExit("fopen error: path=NULL");
    intptr_t i = a_VecChr_writeFileAll(w, path, mod);
    if (i < 0)
        a_errExit("fopen error: %s", path);
    if (i < w->n)
        a_errExit("fwrite error: %s", path);
    return i;
}

a_static void *a_VecChr_stkAdd(a_VecChr *w, intptr_t sz)
{
    a_VecChr_resizeDiff(_arg_  w, + sz);
    return w->p + w->n - sz;
}

a_static void *a_VecChr_stkRmv(a_VecChr *w, intptr_t sz)
{
    return w->p + (w->n -= sz);
}
