#if (a_Version >= 1)
    #define VecChr              a_VecChr
    #define VecChr_ini          a_VecChr_ini
    #define VecChr_ini4         a_VecChr_ini4
    #define VecChr_din          a_VecChr_din
    #define VecChr_din4         a_VecChr_din4
    #define VecChr_reserve      a_VecChr_reserve
    #define VecChr_resize       a_VecChr_resize
    #define VecChr_resizeDiff   a_VecChr_resizeDiff
    #define VecChr_reserveDiff  a_VecChr_reserveDiff
    #define VecChr_reserve0     a_VecChr_reserve0
    #define VecChr_align        a_VecChr_align
    #define VecChr_shrink       a_VecChr_shrink
#endif

a_class(a_VecChr) {
    char *p;
    intptr_t n, n1;
};

a_static void a_VecChr_ini(a_VecChr *w) { w->p = NULL; w->n = w->n1 = 0; }

a_static void a_VecChr_ini4(a_VecChr *w0, a_VecChr *w1, a_VecChr *w2, a_VecChr *w3)
{
    if (w0 != NULL) a_VecChr_ini(w0);
    if (w1 != NULL) a_VecChr_ini(w1);
    if (w2 != NULL) a_VecChr_ini(w2);
    if (w3 != NULL) a_VecChr_ini(w3);
}

a_static void a_VecChr_din(a_VecChr *w) { a_free(_arg_  w->p, w->n1); }

a_static void a_VecChr_din4(a_VecChr *w0, a_VecChr *w1, a_VecChr *w2, a_VecChr *w3)
{
    if (w0 != NULL) a_VecChr_din(w0);
    if (w1 != NULL) a_VecChr_din(w1);
    if (w2 != NULL) a_VecChr_din(w2);
    if (w3 != NULL) a_VecChr_din(w3);
}

a_static void a_VecChr_reserve(a_VecChr *w, intptr_t n)
{
    if (w->n1 < n) {
        intptr_t n1 = w->n1;
        if (n1 < 16/2) n1 = 16/2;
        do {
            n1 *= 2;
        } while (n1 < n);
        w->p = a_realloc(_arg_  w->p, w->n1, n1);
        w->n1 = n1;
    }
}

a_static void a_VecChr_resize(_argDef_  a_VecChr *w, intptr_t n)
{
    #if (a_DbgLv >= 2)
        if (n < 0)
            a_errExit("%s(%d): VecChr_resize: bad size: n=%d", a_fil, a_lin, n);
    #endif
    a_VecChr_reserve(w, n); w->n = n;
}

a_static void a_VecChr_resizeDiff(_argDef_  a_VecChr *w, intptr_t d)
{
    #if (a_DbgLv >= 2)
        if (w->n + d < 0)
            a_errExit("%s(%d): a_VecChr_resizeDiff: bad diff: d=%d", a_fil, a_lin, d);
    #endif
    a_VecChr_resize(_arg_  w, w->n + d);
}

a_static void a_VecChr_reserveDiff(a_VecChr *w, intptr_t d) { a_VecChr_reserve(w, w->n + d); }
a_static void a_VecChr_reserve0(a_VecChr *w) { a_VecChr_reserveDiff(w, 1); w->p[w->n] = '\0'; }

a_static void a_VecChr_align(_argDef_  a_VecChr *w, intptr_t a)
{
    #if (a_DbgLv >= 2)
        if (a <= 0 || (a & (a - 1)) != 0)
            a_errExit("%s(%d): VecChr_align: bad align: a=%d", a_fil, a_lin, a);
    #endif
    while ((w->n & (a - 1)) > 0) {
        a_VecChr_resizeDiff(_arg_  w, 1);
        w->p[w->n - 1] = '\0';
    }
}

a_static void a_VecChr_shrink(_argDef_  a_VecChr *w, intptr_t r)
{
    #if (a_DbgLv >= 2)
        if (r < 0)
            a_errExit("%s(%d): VecChr_shrink: bad reserve: r=%d", a_fil, a_lin, r);
    #endif
    w->p = a_realloc(_arg_  w->p, w->n1, w->n + r);
    w->n1 = w->n + r;
}
