#if (!defined(a_DbgLv))
    #define a_DbgLv     2
#endif
#if (!defined(a_Version))
    #define a_Version   1
#endif

#if (a_DbgLv < 2)
    #define _argDef_
    #define _argDef
    #define _arg_
    #define _arg
#else
    #define _argDef_    const char *a_fil, int a_lin,
    #define _argDef     const char *a_fil, int a_lin
    #define _arg_       __FILE__, __LINE__,
    #define _arg        __FILE__, __LINE__
#endif

#include <ctype.h>
#include <errno.h>
#include <float.h>
#include <inttypes.h>
#include <limits.h>
#include <locale.h>
#include <math.h>
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#if (a_Version >= 1)
    #define static_     a_static
    #define class_      a_class
    #define DbgLv       a_DbgLv
#endif

#if (!defined(a_static))
    #define a_static    static
#endif
#define a_class(nam)    typedef struct nam ## _ nam; struct nam ## _

#if (a_Version >= 1)
    #define errExit     a_errExit
#endif

a_static void a_errExit(const char *f, ...)
{
    va_list ap;
    va_start(ap, f);
    vfprintf(stderr, f, ap);
    va_end(ap);
    fprintf(stderr, "\n");
    exit(1);
}
