#if (defined(AOs_Windows))
    #if (!defined(_WIN32_WINNT))
        #define _WIN32_WINNT 0x0500
    #endif
    #include <windows.h>
#elif (defined(AOs_Linux))
    #include <unistd.h>
#endif

AStatic void aSleepMs(int32_t ms)
{
    #if (defined(AOs_Windows))
        if (ms > 0) Sleep(ms);
    #elif (defined(AOs_Linux))
        if (ms >= 1000) {
            sleep(ms / 1000);
            ms %= 1000;
        }
        if (ms > 0)
            usleep(ms * 1000);
    #endif
}
